package r01mo.model;


/**
 * Interfaz que han de implementar todos los objetos tageables
 * @param <T> tipo del tag: puede ser simplemente un String o un tipo ms complejo
 */
public interface R01MTaggeable<T> {
	/**
	 * Devuelve true si la lista de tags contiene el tag que se pasa como parametro
	 * @param tag el tag
	 * @return true si el tag est en la coleccin
	 */
	public boolean containsTag(final T tag);
	/**
	 * Devuelve true si la lista de tags contiene TODOS los tags que se pasan como parametro
	 * @param tags los tags
	 * @return true si todos los tags estn en la coleccin
	 */
	public boolean containsAllTags(final T... tags);
	/**
	 * Aade un tag a la coleccin de tags
	 * @param tag el tag a aadir
	 * @return true si el tag se ha aadido correctamente
	 */
	public boolean addTag(final T tag);
	/**
	 * Aade una coleccin de tags 
	 * @param tags los tags a aadir
	 * @return true si los tags se han aadido correctamente
	 */
	public boolean addTags(final T... tags);
	/**
	 * Elimina un tag de la coleccin 
	 * @param tag el tag a eliminar
	 * @return true si el tag se ha eliminado correctamente
	 */
	public boolean removeTag(final T tag);
	/**
	 * Borra todos los tags;
	 */
	public void clearTags();
}
