package r01mo.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;

/**
 * Contenedor de Tags
 * @param <T> el tipo del tag: puede ser simplemente un String o un tipo ms complejo
 */
public class R01MTagList<T> extends HashSet<T>
                         implements R01MTaggeable<T> {
	private static final long serialVersionUID = -8744711496254739299L;
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MTagList(Set<T> tags) {
		this.addAll(tags);
	}
	public R01MTagList(T... tags) {
		this.addAll(Arrays.asList(tags));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	METODOS DEL INTERFAZ Taggeable
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public boolean containsTag(final T tag) {
		return this.contains(tag);
	}
	@Override
	public boolean containsAllTags(final T... tags) {
		return this.containsAll(Arrays.asList(tags));
	}
	@Override
	public boolean addTag(final T tag) {
		return this.add(tag);
	}
	@Override
	public boolean addTags(final T... tags) {
		return this.addAll(Arrays.asList(tags));
	}
	@Override
	public boolean removeTag(final T tag) {
		return this.remove(tag);
	}
	@Override
	public void clearTags() {
		this.clear();
	}
}
