package r01mo.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.debug.Debuggable;
import r01mo.model.oids.storage.R01MStorageAreaOID;
import r01mo.model.oids.storage.R01MStorageServerOID;
import r01mo.model.oids.storage.R01MStorageStoreOID;
import r01mo.model.oids.storage.R01MStorageWorkAreaOID;
import r01mo.paths.R01MWorkAreaPath;



/**
 * Localizacin de un contenido en el almacenamiento interno de contenidos
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor @AllArgsConstructor
public class R01MStoreLocation implements R01MModelObject,
								 	      Debuggable {
	private static final long serialVersionUID = 5612778065348235588L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificacin del servidor.
     */
    @Getter @Setter protected R01MStorageServerOID _serverOid;
    /**
     * Identificacin del Repositorio.
     */
    @Getter @Setter protected R01MStorageStoreOID _storeOid;    
    /**
     * Identificacin del Area.
     */
    @Getter @Setter protected R01MStorageAreaOID _areaOid;	
	/**
	 * Identificacin del Area de Trabajo.
	 */
    @Getter @Setter protected R01MStorageWorkAreaOID _workAreaOid;
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////    
    @Override
    public StringBuffer debugInfo() {
        StringBuffer sb = new StringBuffer(72);
        sb.append("\r\n\tServer   : ");sb.append(_serverOid);
        sb.append("\r\n\\tStore   : ");sb.append(_storeOid);
        sb.append("\r\n\tArea     : ");sb.append(_areaOid);
        sb.append("\r\n\tWorkArea : ");sb.append(_workAreaOid);
        sb.append("\r\n");
        return sb;
    }
    /**
     * Obtiene un cdigo memotcnico concatenando cada uno de los objetos separados por ":".
     * @return servidor,repositorio,area y workarea
     */
    public String memoCode() {
        return this.path().asString();
    }
    /**
     * Carga la localizacin del cdigo memotcnico
     * @param memoCode el cdigo memotcnico
     */
    public void fromMemoCode(final String memoCode) {
    	if (memoCode == null) return;
    	Pattern p = Pattern.compile("([^/]+)/([^/]+)/([^/]+)/([^/]+)");
    	Matcher m = p.matcher(memoCode);
    	if (m.find()) {
    		_serverOid = new R01MStorageServerOID(m.group(1));
    		_storeOid = new R01MStorageStoreOID(m.group(2));
    		_areaOid = new R01MStorageAreaOID(m.group(3));
    		_workAreaOid = new R01MStorageWorkAreaOID(m.group(4));
    	}
    }
    public R01MWorkAreaPath path() {
    	return R01MWorkAreaPath.of(this);
    }
}
