package r01mo.model;

import lombok.experimental.Accessors;
import r01f.enums.EnumExtended;
import r01f.enums.EnumExtendedWrapper;


/**
 * Tipo de objeto del modelo
 */
@Accessors(prefix="_")
public enum R01MModelObjectType implements EnumExtended<R01MModelObjectType> {
	CONTENT,
	CONTENT_LANGVERSION,
	CONTENT_DATAFILE,
	CONTENT_LANGVERSION_DATAFILE,
	PORTAL,
	PORTAL_PAGE,
	PORTAL_PAGE_VISUAL_AREA;
	
	private static EnumExtendedWrapper<R01MModelObjectType> _enums = new EnumExtendedWrapper<R01MModelObjectType>(R01MModelObjectType.values());
	
	@Override
	public boolean isIn(R01MModelObjectType... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MModelObjectType other) {
		return _enums.is(this,other);
	}
}
