package r01mo.model;

import java.util.Calendar;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;

/**
 * Informacin de seguimiento del objeto (autor/a, fecha de creacin, modificacin, etc)
 */
@ConvertToDirtyStateTrackable
public class R01MModelObjectTracking implements R01MModelObject {
	private static final long serialVersionUID = 8951212654265804694L;
///////////////////////////////////////////////////////////////////////////////////////////
//	ESTADO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Fecha de creacion del objeto.
     */
    @Getter @Setter private Date _createDate = Calendar.getInstance().getTime();
    /**
     * Cdigo de usuario del creador
     */
    @Getter @Setter private R01MUserCode _creatorUserCode;
    /**
     * Fecha de creacion del objeto.
     */
    @Getter @Setter private Date _lastUpdateDate = Calendar.getInstance().getTime();
    /**
     * Cdigo de usuario de la persona que hizo la ltima modificacin
     */
    @Getter @Setter private R01MUserCode _lastUpdaterUserCode;
}
