package r01mo.model;

import lombok.Getter;
import lombok.Setter;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.common.R01MTemporalPeriod;

/**
 * Informacin de mantenimiento de un objeto del modelo: responsable, periodo de actualizacin, etc
 */
@ConvertToDirtyStateTrackable
public class R01MModelObjectManteinance implements R01MModelObject {
	private static final long serialVersionUID = 5030137256295445423L;
///////////////////////////////////////////////////////////////////////////////////////////
//	ESTADO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Responsable del contenido.
     */
    @Getter @Setter private String _chargePerson;
    /**
     * Fuente del contenido.
     */
    @Getter @Setter private String _source;
    /**
     * Periodicidad de actualizacin del documento.
     */
    @Getter @Setter private R01MTemporalPeriod _updatePeriod;
}
