package r01mo.model;

import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * Parmetros de indexacin 
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor 
public class R01MModelObjectIndexParams implements R01MModelObject {
	private static final long serialVersionUID = -1412482250594037444L;
	
///////////////////////////////////////////////////////////////////////////////////////////
// ESTADO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Indica si el objeto debe ser indexado o no
     * (false = NO habilitar la NO indexacin = indexar)
     */
    @Getter @Setter private boolean _doNotIndexEnabled = false;
    /**
     * Indica si los adjuntos del objeto deben ser indexados o no
     * (false = NO habilitar la NO indexacin = indexar) 
     */
    @Getter @Setter private boolean _doNotIndexAttachmentsEnabled = false;
}
