package r01mo.common.internal;

import r01f.internal.BootstrapGuiceModule;

import com.google.inject.Guice;
import com.google.inject.Injector;

/**
 * IMPORTANTE!!!
 * En GUICE es fundamental tener un nico inyector por JVM; NO se deberan crear mltiples injectores
 * llamando a <code>Guice.createInjector(...)</code>
 */
public class R01MGuiceInjector {
///////////////////////////////////////////////////////////////////////////////////////////
//  SINGLETON HOLDER
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * ver http://java.dzone.com/articles/java-memes-which-refuse-die
	 */
	private enum InjectorSingleton {
		INJECTOR;
		
		private final Injector _guiceInjectorInstance;
		private InjectorSingleton() {
			_guiceInjectorInstance = Guice.createInjector(new BootstrapGuiceModule());		// Inyector nico para R01F con todos los mdulos necesarios
		}
	    public Injector instance() {
	    	return _guiceInjectorInstance;
	    }
	}
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PUBLICOS
/////////////////////////////////////////////////////////////////////////////////////////// 
	/**
	 * Devuelve la instancia del inyector
	 */
	public static Injector instance() {
		return InjectorSingleton.INJECTOR.instance();
	}
}
