package r01mo.common.internal;

import static r01f.locale.Language.BASQUE;
import static r01f.locale.Language.SPANISH;
import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.locale.LanguageTexts;
import r01f.locale.LanguageTexts.LangTextNotFoundBehabiour;

@Accessors(prefix="_")
public enum R01MAppCode {
	CONTENTMANAGER_CORE	("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Ncleo del Gestor de Contenidos")
											 .addForLang(BASQUE,"eu_Ncleo del Gestor de Contenidos")),
	CATALOG_CORE		("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
										     .addForLang(SPANISH,"Ncleo del Gestor de etiquetas de catalogacin")
											 .addForLang(BASQUE,"eu_Ncleo del Gestor de etiquetas de catalogacin")),
	FRAMEWORK			("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Framework: Utilidades Comunes")
											 .addForLang(BASQUE,"eu_Framework: Utilidades Comunes")),
	PORTAL_CORE			("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Ncleo del Gestor de Portales")
											 .addForLang(BASQUE,"eu_Ncleo del Gestor de Portales")),
	PORTAL_VIEW			("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Visualizacin de Portales")
											 .addForLang(BASQUE,"eu_Visualizacin de Portales")),
//	R01I,
	PUBLISHER_CORE		("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Ncleo del Publicador")
											 .addForLang(BASQUE,"eu_Ncleo del Publicador")),
	SEARCHENGINE_CORE	("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Ncleo del Buscador")
											 .addForLang(BASQUE,"eu_Ncleo del Buscador")),
	USER_INTERFACE		("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Interfaz de usuario de los gestores")
											 .addForLang(BASQUE,"eu_Interfaz de usuario de los gestores")),
	API					("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"API de los Gestores")
											 .addForLang(BASQUE,"eu_API de los Gestores")),
	CONFIG_CORE			("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"Ncleo del Gestor de Configuraciones")
											 .addForLang(BASQUE,"eu_Ncleo del Gestor de Configuraciones")),
	INTERNAL_API		("r01d",LanguageTexts.withMissingLangTextBehabiour(LangTextNotFoundBehabiour.RETURN_NULL)
											 .addForLang(SPANISH,"API de uso interno")
											 .addForLang(BASQUE,"eu_API de uso interno"));
///////////////////////////////////////////////////////////////////////////////////////////////////
// 	MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////////////
			private String _code;
	@Getter private LanguageTexts _appNames;
///////////////////////////////////////////////////////////////////////////////////////////////////
// 	METODOS
///////////////////////////////////////////////////////////////////////////////////////////////////	
	public String code() {
		return _code;
	}
	private R01MAppCode(final String appCode,final LanguageTexts names) {
		_code = appCode;
		if (names != null) _appNames = names;
	}
}
