package r01mo.common.internal;

import java.util.Locale;

import r01f.guids.GUIDDispenser;
import r01f.guids.GUIDDispenserManager;
import r01f.internal.R01F;
import r01f.locale.I18NBundle;
import r01f.locale.I18NBundle.MissingKeyBehaviour;
import r01f.locale.I18NServiceFactory;
import r01f.util.types.Strings;
import r01f.xmlproperties.XMLProperties;
import r01f.xmlproperties.XMLPropertiesManager;
import r01f.xmlproperties.XMLPropertyWrapper;

public class R01M {
/////////////////////////////////////////////////////////////////////////////////////////
// ACCESO A PROPIEDADES
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Develve una propiedad en un punto XPath
	 * @param xPath la ruta xPath
	 * @return un wrapper a la propiedad que permite recuperarla en diferentes formatos
	 */
	public static XMLPropertyWrapper propertyAt(final String xPath) {
		XMLPropertiesManager props = R01MGuiceInjector.instance().getInstance(XMLProperties.class).forApp(R01MAppCode.API.code());
		XMLPropertyWrapper prop = new XMLPropertyWrapper(props.of("default"),xPath);
		return prop;
	}
	/**
	 * Devuelve una propiedad en un punto XPath
	 * @param xPathWithPlaceHolders una sentencia XPath con "placeholders" que se sustituyen por variables
	 * @param vars las variables
	 * @return un wrapper a la propiedad que permite recuperarla en diferentes formatos
	 */
	public static XMLPropertyWrapper propertyAt(final String xPathWithPlaceHolders,final String... vars) {
		String theXPath = Strings.of(xPathWithPlaceHolders).customizeWith(vars).asString();
		return R01F.propertyAt(theXPath);
	}
	/**
	 * Devuelve la informacin de uso de la cache en formato imprimible
	 * @param stats la informacion de uso de la cache
	 * @return un String con informacin de depuracin
	 */
	public static String propertiesCacheStatsDebugInfo() {
		XMLPropertiesManager props = R01MGuiceInjector.instance().getInstance(XMLProperties.class).forApp("r01f");
		return props.cacheStatsDebugInfo();
	}
/////////////////////////////////////////////////////////////////////////////////////////
// ACCESO A RESOUCE-BUNDLES
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Obtiene un ResourceBundle para un lenguaje dado
	 * @param lang el lenguaje
	 * @param key la clave
	 * @return el mensaje
	 */
	public static I18NBundle resourceBundleFor(Locale loc) {
		I18NServiceFactory i18nFactory = R01MGuiceInjector.instance().getInstance(I18NServiceFactory.class);
		I18NBundle bundle = i18nFactory.usingResourcesLoaderDefinedIn("r01m/system/properties/resourcesLoader[@name='systemClassPathResourcesLoader']")
									   .forBundleChain("system").withMissingKeyBehaviour(MissingKeyBehaviour.RETURN_KEY)
									   .forLocale(loc);
		return bundle;
	}
	/**
	 * Obtiene un mensaje con una clave determinada para un lenguaje
	 * @param lang el lenguaje
	 * @param key la clave
	 * @return el mensaje
	 */
	public static String messageFor(Locale loc,String key) {
		I18NBundle bundle = R01M.resourceBundleFor(loc);
		return bundle.message(key);
	}
/////////////////////////////////////////////////////////////////////////////////////////
// GENERACIN DE GUIDs
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Genera un GUID
	 * @return el GUID generado
	 */
	public static String generateGUID() {
        GUIDDispenserManager guidDispenserFactory = R01MGuiceInjector.instance().getInstance(GUIDDispenserManager.class);
        GUIDDispenser dispenser = guidDispenserFactory.instanceFor(R01MAppCode.API.code());
        return dispenser.generateGUID();
	}
}
