package r01mo.common;

import java.util.regex.Pattern;

import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithRegEx;
import r01f.enums.EnumWithRegExWrapper;


/**
 * Tipo de recurso
 */
@Accessors(prefix="_")
public enum R01MResourceType implements EnumWithRegEx<R01MResourceType> {
	MIXED(Pattern.compile(".+")),					// todo tipo de recursos
	FOLDER(Pattern.compile("[^.]+")),				// Carpeta
	HTML(Pattern.compile("[^.]+\\.s?html")),		// Fichero HTML
	XML(Pattern.compile("[^.]+\\.xml")),			// Fichero XML
	METADATA(Pattern.compile("[^.]+\\.inc")),		// Metadatos TODO revisar
	VARS(Pattern.compile("[^.]+\\.inc")),			// Variables SSI TODO revisar
	STYLE(Pattern.compile("[^.]+\\.s?css")),		// Hoja de estilos
	SCRIPT(Pattern.compile("[^.]+\\.s?js")),		// Scripts js
	IMAGE(Pattern.compile("[^.]+\\.(?:jpg|gif|bmp")),		// Imagen TODO revisar
	MEDIA(Pattern.compile("[^.]+\\.(?:flv|mov")),			// Videos TODO revisar
	ATTACHMENT(Pattern.compile("[^.]+\\.(?:docx?|xlsx?")),		// Adjuntos TODO revisar
	SYSTEM_DESCRIPTOR(Pattern.compile("[^.]+\\.xml")),			// Descriptor XML del sistema TODO revisar
	SYSTEM_INDEX_FILE(Pattern.compile("[^.]+\\.idx")),			// Fichero de indexacin
	SYSTEM_OPENDATA_PACKAGE(Pattern.compile("[^.]+\\.zip"));	// Paquete opendata TODO revisar
	
	@Getter private final Pattern[] _patterns;
	private R01MResourceType(Pattern... patterns) {
		_patterns = patterns;
	}
	
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithRegEx
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithRegExWrapper<R01MResourceType> _enums = new EnumWithRegExWrapper<R01MResourceType>(R01MResourceType.values());
	
	@Override
	public boolean isIn(R01MResourceType... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MResourceType other) {
		return _enums.is(this,other);
	}
	@Override
	public boolean canBeFrom(String resourcePath) {
		return _enums.canBeFrom(resourcePath);
	}
	/**
	 * Obtiene el elemento del enum que machea el path
	 * @param resourcePath el path
	 * @return el elemento del enum
	 */
	public static R01MResourceType from(String resourcePath) {
		return _enums.fromLabel(resourcePath);
	}
}
