/*
 * Decompiled with CFR 0.152.
 */
package r01f.xmlproperties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.internal.BuiltInObjectsMarshaller;
import r01f.marshalling.Marshaller;
import r01f.resources.ResourcesLoaderDef;
import r01f.resources.ResourcesLoaderFactory;
import r01f.util.types.Strings;
import r01f.xmlproperties.XMLPropertiesCache;
import r01f.xmlproperties.XMLPropertiesCacheFactory;

public final class XMLPropertiesManager {
    private static final Logger log = LoggerFactory.getLogger(XMLPropertiesManager.class);
    XMLPropertiesCache _cache;
    private String _appCode;
    private boolean _useCache = true;

    public XMLPropertiesManager(XMLPropertiesCacheFactory cacheFactory, ResourcesLoaderFactory resourcesLoaderFactory, String appCode, int componentsNumberEstimation) {
        this._appCode = appCode;
        this._cache = cacheFactory.createFor(appCode, componentsNumberEstimation, this._useCache);
    }

    public String cacheStatsDebugInfo() {
        return this._cache.usageStats().debugInfo();
    }

    public ComponentProperties of(String component) {
        return new ComponentProperties(this._appCode, component);
    }

    public class ComponentProperties {
        private String _theAppCode;
        private String _component;

        ComponentProperties(String appCode, String component) {
            this._theAppCode = appCode;
            this._component = component;
        }

        public boolean existProperty(String propXPath) {
            boolean outExists = XMLPropertiesManager.this._cache.existProperty(this._component, propXPath);
            return outExists;
        }

        public String getString(String propXPath) {
            return this.getString(propXPath, null);
        }

        public String getString(String propXPath, String defaultValue) {
            String outStr = XMLPropertiesManager.this._cache.getProperty(this._component, propXPath, defaultValue, String.class);
            return outStr;
        }

        public Strings.StringWrapper getStringWrapped(String propXPath) {
            return Strings.of((CharSequence)this.getString(propXPath));
        }

        public Strings.StringWrapper getStringWrapped(String propXPath, String defaultValue) {
            return Strings.of((CharSequence)this.getString(propXPath, defaultValue));
        }

        public Number getNumber(String propXPath) {
            return this.getNumber(propXPath, null);
        }

        public Number getNumber(String propXPath, Number defaultValue) {
            Number outNum = XMLPropertiesManager.this._cache.getProperty(this._component, propXPath, defaultValue, Number.class);
            return outNum;
        }

        public int getInteger(String propXPath) {
            Number num = this.getNumber(propXPath);
            return num != null ? num.intValue() : Integer.MIN_VALUE;
        }

        public int getInteger(String propXPath, int defaultValue) {
            Number num = this.getNumber(propXPath);
            return num != null ? num.intValue() : defaultValue;
        }

        public float getFloat(String propXPath) {
            Number num = this.getNumber(propXPath);
            return num != null ? num.floatValue() : Float.MIN_VALUE;
        }

        public float getFloat(String propXPath, float defaultValue) {
            Number num = this.getNumber(propXPath);
            return num != null ? num.floatValue() : defaultValue;
        }

        public boolean getBoolean(String propXPath) {
            return this.getBoolean(propXPath, false);
        }

        public boolean getBoolean(String propXPath, boolean defaultValue) {
            Boolean bool = XMLPropertiesManager.this._cache.getProperty(this._component, propXPath, defaultValue, Boolean.class);
            return bool != null ? bool : false;
        }

        public Properties getProperties(String propXPath) {
            Map map = XMLPropertiesManager.this._cache.getProperty(this._component, propXPath, null, Map.class);
            Properties outProps = null;
            if (map != null) {
                outProps = new Properties();
                for (Map.Entry me : map.entrySet()) {
                    if (me.getValue() != null && ((List)me.getValue()).size() == 1) {
                        outProps.put(me.getKey(), ((List)me.getValue()).get(0));
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    Iterator it = ((List)me.getValue()).iterator();
                    while (it.hasNext()) {
                        sb.append('[');
                        sb.append((String)it.next());
                        sb.append(']');
                        if (!it.hasNext()) continue;
                        sb.append(',');
                    }
                    outProps.put(me.getKey(), sb.toString());
                }
            }
            return outProps;
        }

        public Properties getProperties(String propXPath, Properties defaultValue) {
            Properties outProps = this.getProperties(propXPath);
            if (outProps == null) {
                outProps = defaultValue;
            }
            return outProps;
        }

        public List<String> getListOfStrings(String propXPath) {
            String effXPah = propXPath != null && !propXPath.endsWith("/child::*") ? propXPath.concat("/child::*") : propXPath;
            Map map = XMLPropertiesManager.this._cache.getProperty(this._component, effXPah, null, Map.class);
            ArrayList<String> outList = null;
            if (map != null) {
                outList = new ArrayList<String>(map.size());
                for (Map.Entry me : map.entrySet()) {
                    if (me.getValue() != null && ((List)me.getValue()).size() == 1) {
                        outList.add((String)((List)me.getValue()).get(0));
                        continue;
                    }
                    Iterator it = ((List)me.getValue()).iterator();
                    while (it.hasNext()) {
                        outList.add((String)it.next());
                    }
                }
            }
            return outList;
        }

        public List<String> getListOfStrings(String propXPath, List<String> defaultValue) {
            List<String> outList = this.getListOfStrings(propXPath);
            if (outList == null) {
                outList = defaultValue;
            }
            return outList;
        }

        public <T> T getObject(String propXPath, Class<T> objType, Marshaller marshaller) {
            T outObj = XMLPropertiesManager.this._cache.getProperty(this._component, propXPath, null, objType, marshaller);
            if (outObj == null) {
                log.warn("The property {} for appCode/componente={}/{} can not be converted to object {}", (Object[])new String[]{propXPath, this._theAppCode, this._component, objType.getName()});
            }
            return outObj;
        }

        public ResourcesLoaderDef getResourcesLoaderDef(String propXPath) {
            ResourcesLoaderDef outResDef = this.getObject(propXPath, ResourcesLoaderDef.class, BuiltInObjectsMarshaller.instance());
            return outResDef;
        }
    }
}

