/*
 * Decompiled with CFR 0.152.
 */
package r01f.xmlproperties;

import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import r01f.resources.ResourcesLoaderFactory;
import r01f.resources.ResourcesReloadControl;
import r01f.resources.ResourcesReloadControlDef;
import r01f.xml.XMLDocumentBuilder;
import r01f.xmlproperties.XMLPropertiesComponentDef;
import r01f.xmlproperties.XMLPropertiesComponentLoadedListener;
import r01f.xmlproperties.XMLPropertiesException;

class XMLPropertiesForComponentContainer {
    private static final Logger log = LoggerFactory.getLogger(XMLPropertiesForComponentContainer.class);
    ResourcesLoaderFactory _resourcesLoaderFactory;
    private String _appCode;
    private Map<ComponentCacheKey, ComponentCacheXML> _componentsXMLCache;
    private XMLPropertiesComponentLoadedListener _componentLoadedListener;

    XMLPropertiesForComponentContainer(XMLPropertiesComponentLoadedListener componentLoadedListener, ResourcesLoaderFactory resourcesLoaderFactory, String appCode, int componentsNumberEstimation) {
        this._appCode = appCode;
        this._componentLoadedListener = componentLoadedListener;
        this._resourcesLoaderFactory = resourcesLoaderFactory;
        this._componentsXMLCache = new HashMap<ComponentCacheKey, ComponentCacheXML>(componentsNumberEstimation, 0.5f);
    }

    int clear(String component) {
        log.trace("Clearing XML documents cache for {}/{}", (Object)this._appCode, (Object)component);
        int numMatches = 0;
        if (component == null) {
            numMatches = this._componentsXMLCache.size();
            this._componentsXMLCache.clear();
        } else {
            ArrayList<ComponentCacheKey> keysToRemove = new ArrayList<ComponentCacheKey>();
            for (ComponentCacheKey key : this._componentsXMLCache.keySet()) {
                if (!key.isSameAs(component)) continue;
                keysToRemove.add(key);
                ++numMatches;
            }
            if (!keysToRemove.isEmpty()) {
                for (ComponentCacheKey key : keysToRemove) {
                    ComponentCacheXML removedComp = this._componentsXMLCache.remove(key);
                    if (removedComp == null) continue;
                    ++numMatches;
                }
            }
        }
        return numMatches;
    }

    boolean reloadIfNecessary(String component) {
        long timeElapsed;
        boolean outReload = false;
        ComponentCacheXML comp = this._retrieveComponent(component);
        if (comp == null) {
            return false;
        }
        ResourcesReloadControl reloadControlImpl = comp.getReloadControlImpl();
        if (reloadControlImpl == null) {
            return false;
        }
        long checkInterval = comp.getCompDef().getLoaderDef().getReloadControlDef().checkIntervalMillis();
        if (checkInterval > 0L && (timeElapsed = System.currentTimeMillis() - comp.getLoadTimeStamp()) > checkInterval && (outReload = reloadControlImpl.needsReload(component))) {
            log.debug("***** RELOAD component {}/{} ******", (Object)this._appCode, (Object)component);
            this.clear(component);
        }
        return outReload;
    }

    Node getPropertyNode(String component, String xPath) {
        return (Node)this.getPropertyNode(component, xPath, XPathConstants.NODE);
    }

    NodeList getPropertyNodeList(String component, String xPath) {
        String effXPath = xPath != null && !xPath.endsWith("/child::*") ? xPath.concat("/child::*") : xPath;
        return (NodeList)this.getPropertyNode(component, effXPath, XPathConstants.NODESET);
    }

    Object getPropertyNode(String component, String propXPath, QName returnType) {
        ComponentCacheXML comp = this._retrieveComponent(component);
        if (comp == null) {
            return null;
        }
        String thePropXPath = null;
        try {
            Object outObj = null;
            thePropXPath = propXPath.trim();
            if (thePropXPath.startsWith("/")) {
                thePropXPath = thePropXPath.substring(1);
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpr = xPath.compile(thePropXPath);
            if (returnType == XPathConstants.BOOLEAN) {
                outObj = xPathExpr.evaluate(comp.getXml(), XPathConstants.BOOLEAN);
            } else if (returnType == XPathConstants.NUMBER) {
                outObj = xPathExpr.evaluate(comp.getXml(), XPathConstants.NUMBER);
            } else if (returnType == XPathConstants.STRING) {
                outObj = xPathExpr.evaluate(comp.getXml(), XPathConstants.STRING);
            } else if (returnType == XPathConstants.NODE) {
                outObj = xPathExpr.evaluate(comp.getXml(), XPathConstants.NODE);
            } else if (returnType == XPathConstants.NODESET) {
                outObj = xPathExpr.evaluate(comp.getXml(), XPathConstants.NODESET);
            }
            return outObj;
        }
        catch (XPathExpressionException xPathEx) {
            log.warn("Error retrieving property at {} for {}/{}", (Object[])new String[]{thePropXPath, this._appCode, component});
            xPathEx.printStackTrace(System.out);
            return null;
        }
    }

    private ComponentCacheXML _retrieveComponent(String component) {
        ComponentCacheXML outComp = null;
        try {
            XMLPropertiesComponentDef compDef;
            ComponentCacheKey key = new ComponentCacheKey(component);
            outComp = this._componentsXMLCache.get(key);
            if (outComp == null && (compDef = XMLPropertiesComponentDef.load(this._appCode, component)) != null) {
                log.trace("Loading properties for {}/{} with component definition:{}", (Object[])new String[]{this._appCode, component, compDef.debugInfo().toString()});
                this._componentLoadedListener.newComponentLoaded(compDef);
                Document xmlDoc = this._loadComponentXML(compDef);
                ResourcesReloadControl reloadControlImpl = this._loadReloadControlImpl(compDef);
                outComp = new ComponentCacheXML(compDef, System.currentTimeMillis(), reloadControlImpl, xmlDoc);
                this._componentsXMLCache.put(key, outComp);
            }
        }
        catch (XMLPropertiesException xmlPropsEx) {
            xmlPropsEx.printStackTrace(System.out);
        }
        return outComp;
    }

    private Document _loadComponentXML(XMLPropertiesComponentDef compDef) throws XMLPropertiesException {
        XMLDocumentBuilder domBuilder = new XMLDocumentBuilder(this._resourcesLoaderFactory.createResourcesLoaderFor(compDef.getLoaderDef()));
        Document xmlDoc = null;
        try {
            xmlDoc = domBuilder.buildXMLDOM(compDef.getPropertiesFileURI(), new String[0]);
        }
        catch (SAXException saxEx) {
            throw Throwables.getRootCause((Throwable)saxEx) instanceof FileNotFoundException ? new XMLPropertiesException().propertiesLoadError(this._appCode, compDef.getName()) : new XMLPropertiesException().propertiesXMLError(this._appCode, compDef.getName());
        }
        return xmlDoc;
    }

    private ResourcesReloadControl _loadReloadControlImpl(XMLPropertiesComponentDef compDef) {
        ResourcesReloadControlDef reloadControlDef = compDef.getLoaderDef().getReloadControlDef();
        if (reloadControlDef == null) {
            return null;
        }
        ResourcesReloadControl outReloadControl = this._resourcesLoaderFactory.createReloadControlFor(reloadControlDef);
        outReloadControl.setProperties(reloadControlDef.getControlProps());
        return outReloadControl;
    }

    private class ComponentCacheKey {
        private String _component;

        boolean isSameAs(String ... keyComponent) {
            boolean isSame = false;
            if (keyComponent.length == 1) {
                isSame = this.composeKey(this._component).equals(this.composeKey(keyComponent[0]));
            }
            return isSame;
        }

        String composeKey(String ... keyComponent) {
            String outKey = null;
            if (keyComponent.length == 1) {
                outKey = keyComponent[0];
            }
            return outKey;
        }

        public String getComponent() {
            return this._component;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentCacheKey)) {
                return false;
            }
            ComponentCacheKey other = (ComponentCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$_component = this.getComponent();
            String other$_component = other.getComponent();
            return !(this$_component == null ? other$_component != null : !this$_component.equals(other$_component));
        }

        public boolean canEqual(Object other) {
            return other instanceof ComponentCacheKey;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            String $_component = this.getComponent();
            result = result * 31 + ($_component == null ? 0 : $_component.hashCode());
            return result;
        }

        public String toString() {
            return "XMLPropertiesForComponentContainer.ComponentCacheKey(_component=" + this.getComponent() + ")";
        }

        @ConstructorProperties(value={"_component"})
        public ComponentCacheKey(String _component) {
            this._component = _component;
        }
    }

    private class ComponentCacheXML {
        private XMLPropertiesComponentDef _compDef;
        private long _loadTimeStamp;
        private ResourcesReloadControl _reloadControlImpl;
        private Document _xml;

        public XMLPropertiesComponentDef getCompDef() {
            return this._compDef;
        }

        public long getLoadTimeStamp() {
            return this._loadTimeStamp;
        }

        public ResourcesReloadControl getReloadControlImpl() {
            return this._reloadControlImpl;
        }

        public Document getXml() {
            return this._xml;
        }

        @ConstructorProperties(value={"_compDef", "_loadTimeStamp", "_reloadControlImpl", "_xml"})
        public ComponentCacheXML(XMLPropertiesComponentDef _compDef, long _loadTimeStamp, ResourcesReloadControl _reloadControlImpl, Document _xml) {
            this._compDef = _compDef;
            this._loadTimeStamp = _loadTimeStamp;
            this._reloadControlImpl = _reloadControlImpl;
            this._xml = _xml;
        }
    }
}

