/*
 * Decompiled with CFR 0.152.
 */
package r01f.xmlproperties;

import r01f.exceptions.EnrichedException;
import r01f.exceptions.EnrichedExceptionCustomizationsInterfaces;
import r01f.util.types.Strings;
import r01f.xmlproperties.XMLPropertiesComponentDef;

public class XMLPropertiesException
extends EnrichedException {
    private static final long serialVersionUID = -285396264237852297L;

    public XMLPropertiesException() {
    }

    public XMLPropertiesException(String msg) {
        super(msg);
    }

    public XMLPropertiesException(Throwable otherEx) {
        super(otherEx);
    }

    public XMLPropertiesException(String msg, Throwable otherEx) {
        super(msg, otherEx);
    }

    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<XMLPropertiesException, XMLPropertiesExceptionSubTypes> customized() {
        return super.customized();
    }

    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsReader<XMLPropertiesException, XMLPropertiesExceptionSubTypes> customizations() {
        return super.customizations();
    }

    public XMLPropertiesException componentDefLoadError(String appCode, String component) {
        String err = Strings.of((CharSequence)"Error al cargar el xml de definicion del appCode/component={}/{}; Asegurate de que existe el fichero /components/{}.{}.xml  en el classPath de la aplicacion (ej: /config/[appCode]/components/{}.{}.xml").customizeWith(appCode, component).asString();
        this.customized().withMessage(err).fatal().developerWarn().subClass(XMLPropertiesExceptionSubTypes.COMPONENTDEF_NOT_FOUND).inGroup(1).withCode(1);
        return this;
    }

    public XMLPropertiesException componentDefXMLError(String appCode, String component) {
        String err = Strings.of((CharSequence)"Error en el XML de definicion del appCode/component {}/{}. Revisa el fichero /components/{}.{}.xml en el classPath de la aplicaci\u00f3n (ej: /config/[appCode]/components/{}.{}.xml").customizeWith(appCode, component).asString();
        this.customized().withMessage(err).fatal().developerWarn().subClass(XMLPropertiesExceptionSubTypes.COMPONENTDEF_XML_MALFORMED).inGroup(1).withCode(2);
        return this;
    }

    public XMLPropertiesException propertiesLoadError(String appCode, String component) {
        XMLPropertiesComponentDef compDef = null;
        try {
            compDef = XMLPropertiesComponentDef.load(appCode, component);
        }
        catch (XMLPropertiesException xMLPropertiesException) {
            // empty catch block
        }
        String err = Strings.of((CharSequence)"NO se encuentra el fichero XML con las propiedades para appCode/component={}/{} cargado con la definici\u00f3n:{}").customizeWith(appCode, component, compDef != null ? compDef.debugInfo() : "DEFINICION NO ENCONTRADA").asString();
        this.customized().withMessage(err).fatal().developerWarn().subClass(XMLPropertiesExceptionSubTypes.PROPERTIES_NOT_FOUND).inGroup(1).withCode(1);
        return this;
    }

    public XMLPropertiesException propertiesXMLError(String appCode, String component) {
        String err = Strings.of((CharSequence)"Error en el XML de propiedades para appCode/contentType={}/{} (el XML tiene algun error.").customizeWith(appCode, component).asString();
        this.customized().withMessage(err).fatal().developerWarn().subClass(XMLPropertiesExceptionSubTypes.PROPERTIES_XML_MALFORMED).inGroup(1).withCode(2);
        return this;
    }

    static enum XMLPropertiesExceptionSubTypes {
        COMPONENTDEF_NOT_FOUND,
        COMPONENTDEF_XML_MALFORMED,
        PROPERTIES_NOT_FOUND,
        PROPERTIES_XML_MALFORMED;

    }
}

