/*
 * Decompiled with CFR 0.152.
 */
package r01f.xmlproperties;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import r01f.debug.Debuggable;
import r01f.internal.BuiltInObjectsMarshaller;
import r01f.marshalling.MarshallerException;
import r01f.resources.ResourcesLoader;
import r01f.resources.ResourcesLoaderDef;
import r01f.resources.ResourcesLoaderFactory;
import r01f.util.types.Strings;
import r01f.xmlproperties.XMLPropertiesCacheImpl;
import r01f.xmlproperties.XMLPropertiesException;

class XMLPropertiesComponentDef
implements Serializable,
Debuggable {
    private static final long serialVersionUID = 646222659405032701L;
    private String _name;
    private ResourcesLoaderDef _loaderDef;
    private String _propertiesFileURI;
    private int _numberOfPropertiesEstimation = XMLPropertiesCacheImpl.DEFAULT_PROPERTIES_PER_COMPONENT;

    @Override
    public CharSequence debugInfo() {
        return Strings.create().addCustomized("\r\n           Name: {}", this._name).addCustomized("\r\npropsEstimation: {}", Integer.toString(this._numberOfPropertiesEstimation)).addCustomized("\r\n        fileUri: {}", this._propertiesFileURI).addCustomized("\r\n         loader: {}", this._loaderDef != null ? this._loaderDef.debugInfo() : "");
    }

    public static XMLPropertiesComponentDef load(String appCode, String component) throws XMLPropertiesException {
        XMLPropertiesComponentDef outDef;
        block8: {
            outDef = null;
            try {
                String filePath = Strings.of((CharSequence)"components/{}.{}.xml").customizeWith(appCode, component).asString();
                ResourcesLoader resourcesLoader = ResourcesLoaderFactory.DEFAULT_RESOURCES_LOADER;
                InputStream defXmlIS = resourcesLoader.getInputStream(filePath, true);
                try {
                    if (defXmlIS != null) {
                        outDef = (XMLPropertiesComponentDef)BuiltInObjectsMarshaller.instance().beanFromXml(defXmlIS);
                        break block8;
                    }
                    throw new XMLPropertiesException().componentDefLoadError(appCode, component);
                }
                finally {
                    if (Collections.singletonList(defXmlIS).get(0) != null) {
                        defXmlIS.close();
                    }
                }
            }
            catch (MarshallerException msEx) {
                throw new XMLPropertiesException(msEx).componentDefXMLError(appCode, component);
            }
            catch (IOException ioEx) {
                throw new XMLPropertiesException(ioEx).componentDefLoadError(appCode, component);
            }
        }
        outDef.setName(component);
        return outDef;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String _name) {
        this._name = _name;
    }

    public ResourcesLoaderDef getLoaderDef() {
        return this._loaderDef;
    }

    public void setLoaderDef(ResourcesLoaderDef _loaderDef) {
        this._loaderDef = _loaderDef;
    }

    public String getPropertiesFileURI() {
        return this._propertiesFileURI;
    }

    public void setPropertiesFileURI(String _propertiesFileURI) {
        this._propertiesFileURI = _propertiesFileURI;
    }

    public int getNumberOfPropertiesEstimation() {
        return this._numberOfPropertiesEstimation;
    }

    public void setNumberOfPropertiesEstimation(int _numberOfPropertiesEstimation) {
        this._numberOfPropertiesEstimation = _numberOfPropertiesEstimation;
    }
}

