/*
 * Decompiled with CFR 0.152.
 */
package r01f.xmlproperties;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import r01f.marshalling.Marshaller;
import r01f.marshalling.MarshallerException;
import r01f.resources.ResourcesLoaderFactory;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;
import r01f.xml.XMLStringSerializer;
import r01f.xml.XMLUtils;
import r01f.xmlproperties.XMLPropertiesCache;
import r01f.xmlproperties.XMLPropertiesComponentDef;
import r01f.xmlproperties.XMLPropertiesComponentLoadedListener;
import r01f.xmlproperties.XMLPropertiesForComponentContainer;

class XMLPropertiesCacheImpl
implements XMLPropertiesCache,
XMLPropertiesComponentLoadedListener {
    private static final Logger log = LoggerFactory.getLogger(XMLPropertiesCacheImpl.class);
    static int DEFAULT_COMPONENTS_NUMBER = 30;
    static int DEFAULT_PROPERTIES_PER_COMPONENT = 1000;
    private XMLPropertiesForComponentContainer _componentXMLManager;
    private Map<CacheKey, CacheValue> _cache;
    private String _appCode;
    private boolean _useCache = true;

    @Inject
    public XMLPropertiesCacheImpl(ResourcesLoaderFactory resourcesLoaderFactory, @Assisted String appCode, @Assisted int componentsNumberEstimation, @Assisted boolean useCache) {
        this._appCode = appCode;
        this._useCache = useCache;
        this._componentXMLManager = new XMLPropertiesForComponentContainer(this, resourcesLoaderFactory, this._appCode, componentsNumberEstimation);
    }

    @Override
    public void newComponentLoaded(XMLPropertiesComponentDef def) {
        this._ensureCapacity(def.getNumberOfPropertiesEstimation());
    }

    private void _ensureCapacity(int propertiesPerComponentEstimation) {
        float cacheMapLoadFactor = 0.5f;
        if (this._cache == null) {
            int cacheSize = propertiesPerComponentEstimation + 100;
            log.trace("Crating a {} positions cache for every component of {}", (Object)Integer.toString(cacheSize), (Object)this._appCode);
            this._cache = new HashMap<CacheKey, CacheValue>(cacheSize, 0.5f);
        } else {
            int cacheSize = this._cache.size() + propertiesPerComponentEstimation + 100;
            log.trace("Resizing cache to add {} positions; final size: {}", (Object)Integer.toString(propertiesPerComponentEstimation), (Object)Integer.toString(cacheSize));
            HashMap<CacheKey, CacheValue> tempCache = new HashMap<CacheKey, CacheValue>(cacheSize, 0.5f);
            tempCache.putAll(this._cache);
            this._cache = tempCache;
        }
    }

    @Override
    public int clear() {
        return this.clear(null);
    }

    @Override
    public int clear(String component) {
        log.trace("clearing cached properties for component {} of {}", (Object)component, (Object)this._appCode);
        if (this._cache == null) {
            return 0;
        }
        int numMatches = 0;
        if (component == null) {
            numMatches = this._cache.size();
            this._cache.clear();
        } else {
            ArrayList<CacheKey> keysToRemove = new ArrayList<CacheKey>();
            for (CacheKey key : this._cache.keySet()) {
                if (!key.isSameAs(component)) continue;
                keysToRemove.add(key);
                ++numMatches;
            }
            if (!keysToRemove.isEmpty()) {
                for (CacheKey key : keysToRemove) {
                    CacheValue removedProperty = this._cache.remove(key);
                    if (removedProperty == null) continue;
                    ++numMatches;
                }
            }
        }
        return numMatches;
    }

    @Override
    public CacheStatistics usageStats() {
        CacheStatistics outStats = new CacheStatistics();
        for (CacheValue val : this._cache.values()) {
            if (val.getPropValue() != null) {
                if (val.isDefaultValue()) {
                    outStats.setDefaultCount(outStats.getDefaultCount() + val.getAccessCount());
                    continue;
                }
                outStats.setHitCount(outStats.getHitCount() + val.getAccessCount() - 1L);
                outStats.setNonHitCount(outStats.getNonHitCount() + 1L);
                continue;
            }
            outStats.setInvalidCount(outStats.getInvalidCount() + val.getAccessCount());
        }
        return outStats;
    }

    @Override
    public boolean existProperty(String component, String propXPath) {
        CacheValue propValue = this._retrieve(component, propXPath, null, null);
        if (propValue != null) {
            return true;
        }
        Node node = this._componentXMLManager.getPropertyNode(component, propXPath);
        return node != null;
    }

    @Override
    public <T> T getProperty(String component, String propXPath, T defaultValue, Class<T> type) {
        T outObj = this.getProperty(component, propXPath, defaultValue, type, null);
        return outObj;
    }

    @Override
    public <T> T getProperty(String component, String propXPath, T defaultValue, Class<T> type, Marshaller marshaller) {
        CacheValue value = this._retrieve(component, propXPath, type, marshaller);
        Object outObj = value.getPropValue();
        if (outObj == null && defaultValue != null) {
            outObj = defaultValue;
            value.setValue(defaultValue, true);
        }
        return (T)outObj;
    }

    private String _retrieveStringProperty(String component, String propXPath) {
        String outStr = null;
        Node node = this._componentXMLManager.getPropertyNode(component, propXPath);
        if (node != null) {
            outStr = XMLUtils.isTextNode(node = node.getFirstChild()) ? node.getTextContent() : XMLStringSerializer.writeNode(node, null);
        }
        return outStr;
    }

    private Map<String, List<String>> _retrieveMapOfStringsProperty(String component, String propXPath) {
        HashMap<String, ArrayList<String>> outMap = null;
        NodeList nodeList = this._componentXMLManager.getPropertyNodeList(component, propXPath);
        if (nodeList != null && nodeList.getLength() > 0) {
            outMap = new HashMap<String, ArrayList<String>>(nodeList.getLength());
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                String nodeName = node.getLocalName();
                String nodeStrValue = null;
                Node contentNode = node.getFirstChild();
                nodeStrValue = XMLUtils.isTextNode(contentNode) ? contentNode.getTextContent() : XMLStringSerializer.writeNode(contentNode, null);
                if (nodeStrValue != null) {
                    ArrayList<String> currItemValue = (ArrayList<String>)outMap.get(nodeName);
                    if (currItemValue == null) {
                        currItemValue = new ArrayList<String>();
                        outMap.put(nodeName, currItemValue);
                    }
                    currItemValue.add(nodeStrValue);
                    outMap.put(nodeName, currItemValue);
                }
                ++i;
            }
        }
        return outMap;
    }

    private <T> T _retrieveBeanPropertyUsingMarshaller(String component, String propXPath, Class<?> type, Marshaller marshaller) {
        T outObj = null;
        if (marshaller == null) {
            log.warn("Error transforming property {} from {}/{} to an object using r01 Marshaller: the provided marshaller is null", (Object[])new String[]{propXPath, this._appCode, component});
        } else {
            Node node = this._componentXMLManager.getPropertyNode(component, propXPath);
            if (node != null) {
                try {
                    outObj = marshaller.beanFromXml(node);
                }
                catch (MarshallerException msEx) {
                    String err = Strings.of((CharSequence)"Error transforming property {} from {}/{} to an object using r01 Marshaller: {}").customizeWith(propXPath, this._appCode, component, msEx.getMessage()).asString();
                    log.error(err, (Throwable)msEx);
                }
            }
        }
        return outObj;
    }

    private <T> CacheValue _retrieve(String component, String xPath, Class<T> type, Marshaller marshaller) {
        boolean hasToClear = this._componentXMLManager.reloadIfNecessary(component);
        if (hasToClear) {
            this.clear(component);
        }
        CacheKey key = new CacheKey(component, xPath);
        CacheValue value = null;
        if (this._useCache && (value = this._cache.get(key)) != null) {
            value.anotherHit();
        }
        if (value == null && type != null) {
            Object obj = null;
            if (type.equals(String.class)) {
                obj = this._retrieveStringProperty(component, xPath);
            } else if (type.equals(Number.class)) {
                String numStr = this._retrieveStringProperty(component, xPath);
                try {
                    Number num = NumberUtils.createNumber((String)numStr);
                    obj = num;
                }
                catch (NumberFormatException nfEx) {
                    log.warn("Property {} from appCode/component={}/{}: {} cannot be converted to a Number!", (Object[])new String[]{xPath, this._appCode, component, numStr});
                }
            } else if (type.equals(Boolean.class)) {
                String bolStr = this._retrieveStringProperty(component, xPath);
                Boolean bool = BooleanUtils.toBooleanObject((String)bolStr);
                if (bolStr != null && bool == null) {
                    log.debug("Property {} from appCode/component={}/{}: {} cannot be converted to a boolean!", (Object[])new String[]{xPath, this._appCode, component, bolStr});
                }
                obj = bool;
            } else if (CollectionUtils.isMap(type)) {
                obj = this._retrieveMapOfStringsProperty(component, xPath);
            } else if (marshaller != null) {
                obj = this._retrieveBeanPropertyUsingMarshaller(component, xPath, type, marshaller);
            } else {
                log.warn("{} type is not a supported for a property. Property {} from appCode/component={}/{}: cannot be converted", (Object[])new String[]{type.getName(), xPath, this._appCode, component});
            }
            value = this._store(component, xPath, obj, false);
        }
        return value;
    }

    private CacheValue _store(String component, String xPath, Object obj, boolean isDefaultVal) {
        CacheKey key = new CacheKey(component, xPath);
        CacheValue value = new CacheValue(1L, System.currentTimeMillis(), obj, isDefaultVal);
        this._cache.put(key, value);
        return value;
    }

    private class CacheKey {
        private String _component;
        private String _propXPath;

        boolean isSameAs(String ... keyComponent) {
            boolean isSame = false;
            if (keyComponent.length == 2) {
                isSame = this.composeKey(this._component).equals(this.composeKey(keyComponent[0], keyComponent[1]));
            } else if (keyComponent.length == 1) {
                isSame = this.composeKey(this._component).equals(this.composeKey(keyComponent[0]));
            }
            return isSame;
        }

        String composeKey(String ... keyComponent) {
            String outKey = null;
            if (keyComponent.length == 2) {
                outKey = String.valueOf(keyComponent[0]) + "." + keyComponent[1];
            } else if (keyComponent.length == 1) {
                outKey = keyComponent[0];
            }
            return outKey;
        }

        public String getComponent() {
            return this._component;
        }

        public String getPropXPath() {
            return this._propXPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$_component = this.getComponent();
            String other$_component = other.getComponent();
            if (this$_component == null ? other$_component != null : !this$_component.equals(other$_component)) {
                return false;
            }
            String this$_propXPath = this.getPropXPath();
            String other$_propXPath = other.getPropXPath();
            return !(this$_propXPath == null ? other$_propXPath != null : !this$_propXPath.equals(other$_propXPath));
        }

        public boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            String $_component = this.getComponent();
            result = result * 31 + ($_component == null ? 0 : $_component.hashCode());
            String $_propXPath = this.getPropXPath();
            result = result * 31 + ($_propXPath == null ? 0 : $_propXPath.hashCode());
            return result;
        }

        public String toString() {
            return "XMLPropertiesCacheImpl.CacheKey(_component=" + this.getComponent() + ", _propXPath=" + this.getPropXPath() + ")";
        }

        @ConstructorProperties(value={"_component", "_propXPath"})
        public CacheKey(String _component, String _propXPath) {
            this._component = _component;
            this._propXPath = _propXPath;
        }
    }

    class CacheStatistics {
        private long _hitCount;
        private long _nonHitCount;
        private long _invalidCount;
        private long _defaultCount;

        public String debugInfo() {
            StringBuilder invalidPropsStr = new StringBuilder("");
            return Strings.create().add((CharSequence)"Estadisticas de uso de la cache de XMLProperties:").add((CharSequence)"\r\n     Hits: ").add((CharSequence)Long.toString(this._hitCount)).add((CharSequence)"\r\n  NO-Hits: ").add((CharSequence)Long.toString(this._nonHitCount)).add((CharSequence)"\r\n Defaults: ").add((CharSequence)Long.toString(this._defaultCount)).add((CharSequence)"\r\n Invalids: ").add((CharSequence)Long.toString(this._invalidCount)).add((CharSequence)"\r\n").add((CharSequence)invalidPropsStr).asString();
        }

        public long getHitCount() {
            return this._hitCount;
        }

        public void setHitCount(long _hitCount) {
            this._hitCount = _hitCount;
        }

        public long getNonHitCount() {
            return this._nonHitCount;
        }

        public void setNonHitCount(long _nonHitCount) {
            this._nonHitCount = _nonHitCount;
        }

        public long getInvalidCount() {
            return this._invalidCount;
        }

        public void setInvalidCount(long _invalidCount) {
            this._invalidCount = _invalidCount;
        }

        public long getDefaultCount() {
            return this._defaultCount;
        }

        public void setDefaultCount(long _defaultCount) {
            this._defaultCount = _defaultCount;
        }
    }

    private class CacheValue {
        private long _accessCount;
        private long _lastAcessTimeStamp;
        private Object _propValue;
        private boolean _defaultValue;

        public void anotherHit() {
            ++this._accessCount;
            this._lastAcessTimeStamp = System.currentTimeMillis();
        }

        public void setValue(Object val, boolean defaultVal) {
            this._propValue = val;
            this._defaultValue = defaultVal;
        }

        public long getAccessCount() {
            return this._accessCount;
        }

        public long getLastAcessTimeStamp() {
            return this._lastAcessTimeStamp;
        }

        public Object getPropValue() {
            return this._propValue;
        }

        public boolean isDefaultValue() {
            return this._defaultValue;
        }

        public CacheValue() {
        }

        @ConstructorProperties(value={"_accessCount", "_lastAcessTimeStamp", "_propValue", "_defaultValue"})
        public CacheValue(long _accessCount, long _lastAcessTimeStamp, Object _propValue, boolean _defaultValue) {
            this._accessCount = _accessCount;
            this._lastAcessTimeStamp = _lastAcessTimeStamp;
            this._propValue = _propValue;
            this._defaultValue = _defaultValue;
        }
    }
}

