/*
 * Decompiled with CFR 0.152.
 */
package r01f.xmlproperties;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.resources.ResourcesLoaderFactory;
import r01f.xmlproperties.XMLPropertiesCacheFactory;
import r01f.xmlproperties.XMLPropertiesManager;

public class XMLProperties {
    private static final Logger log = LoggerFactory.getLogger(XMLProperties.class);
    private Map<String, XMLPropertiesManager> _propertiesManagerForAppCache;
    private ResourcesLoaderFactory _resourcesLoaderFactory;
    private XMLPropertiesCacheFactory _cacheFactory;

    @Inject
    public XMLProperties(XMLPropertiesCacheFactory cacheFactory, ResourcesLoaderFactory resourcesLoaderFactory) {
        log.trace("XMLProperties BootStraping!!!!");
        this._cacheFactory = cacheFactory;
        this._resourcesLoaderFactory = resourcesLoaderFactory;
    }

    public XMLPropertiesManager forApp(String appCode) {
        XMLPropertiesManager manager;
        XMLPropertiesManager xMLPropertiesManager = manager = this._propertiesManagerForAppCache != null ? this._propertiesManagerForAppCache.get(appCode) : null;
        if (manager == null) {
            log.trace("The properties for application {} are not present in the cache: they must be loaded NOW", (Object)appCode);
            manager = new XMLPropertiesManager(this._cacheFactory, this._resourcesLoaderFactory, appCode, 10);
            this._propertiesManagerForAppCache = new HashMap<String, XMLPropertiesManager>(15, 0.5f);
            this._propertiesManagerForAppCache.put(appCode, manager);
        }
        return manager;
    }
}

