/*
 * Decompiled with CFR 0.152.
 */
package r01f.xmlproperties;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import r01f.internal.BootstrapGuiceModule;
import r01f.marshalling.TestObj;
import r01f.marshalling.TestXOMarshaller;
import r01f.resources.ResourcesLoaderDef;
import r01f.xmlproperties.XMLProperties;
import r01f.xmlproperties.XMLPropertyWrapper;

public class TestXMLProperties {
    public static void main(String[] args) {
        try {
            int testTimes = 200;
            boolean debug = false;
            long[] marks = new long[testTimes];
            System.out.println("\r\n\r\n...start!");
            TestXMLPropertiesAccessor propsAccessor = (TestXMLPropertiesAccessor)Guice.createInjector((Module[])new Module[]{new BootstrapGuiceModule()}).getInstance(TestXMLPropertiesAccessor.class);
            int i = 0;
            while (i < testTimes) {
                long t1 = System.nanoTime();
                String prop1 = propsAccessor.at("/properties/a/b").asString();
                String prop2 = propsAccessor.at("/properties/c/@attr").asString();
                float prop3 = propsAccessor.at("/properties/d").asFloat();
                boolean prop4 = propsAccessor.at("/properties/e/@bol").asBoolean();
                String invalidProp5 = propsAccessor.at("/aaa").asString();
                Properties prop6 = propsAccessor.at("/properties/myProps").asProperties();
                List<String> prop7 = propsAccessor.at("/properties/myList").asListOfStrings();
                TestObj prop8 = propsAccessor.at("properties/testObj").asObject(TestObj.class, TestXOMarshaller.marshaller());
                String defProp9 = propsAccessor.at("no_existe").asString("valor por defecto");
                ResourcesLoaderDef prop10 = propsAccessor.at("properties/resourcesLoader[@name='myClassPathResourcesLoader']").asResourcesLoaderDef();
                long t2 = System.nanoTime();
                marks[i] = t2 - t1;
                if (debug) {
                    System.out.println("Valores simples: " + prop1 + "-" + prop2 + "-" + prop3 + "-" + prop4);
                    if (prop6 != null) {
                        System.out.println("Properties: ");
                        for (Map.Entry<Object, Object> prop : prop6.entrySet()) {
                            System.out.println("\t" + prop.getKey() + "-" + prop.getValue());
                        }
                    }
                    if (prop7 != null) {
                        System.out.println("List:");
                        StringBuilder sb = new StringBuilder();
                        for (String s : prop7) {
                            sb.append(String.valueOf(s) + ",");
                        }
                        System.out.println("\t" + sb);
                    }
                    if (prop8 != null) {
                        System.out.println("Objeto: ");
                        System.out.println(prop8.toString());
                    }
                    if (prop10 != null) {
                        System.out.println("ResourcesLoader: ");
                        System.out.println(prop10.debugInfo());
                    }
                }
                if (i < testTimes - 1) {
                    System.out.println("...sleeping!!");
                    Thread.sleep(1000L);
                }
                ++i;
            }
            System.out.println("\r\n\r\n\r\n");
            long avg = 0L;
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            int i2 = 0;
            while (i2 < testTimes) {
                System.out.println("<" + i2 + ">\t[" + nf.format(marks[i2]) + "]");
                if (i2 > 1) {
                    avg += marks[i2];
                }
                ++i2;
            }
            System.out.println("------------------------------");
            System.out.println("\t[" + nf.format(avg / (long)testTimes) + "] nanos\r\n\r\n");
            System.out.println("\r\n\r\n\r\n" + propsAccessor.cacheStatsDebugInfo());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class TestXMLPropertiesAccessor {
        @Inject
        XMLProperties props;

        public XMLPropertyWrapper at(String xPath) {
            XMLPropertyWrapper prop = new XMLPropertyWrapper(this.props.forApp("r01fb").of("test"), xPath);
            return prop;
        }

        public String cacheStatsDebugInfo() {
            return this.props.forApp("r01fb").cacheStatsDebugInfo();
        }
    }
}

