/*
 * Decompiled with CFR 0.152.
 */
package r01f.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XSLTransformer {
    private Source _xslSrc;
    private Properties _transformerParams;
    private Transformer _transformer;

    public XSLTransformer() {
    }

    public XSLTransformer(InputStream xslIS, Properties transformerParams) throws TransformerConfigurationException {
        this._xslSrc = new StreamSource(xslIS);
        this._transformerParams = transformerParams;
        this._initTransformer();
    }

    public XSLTransformer(Reader xslReader, Properties transformerParams) throws TransformerConfigurationException {
        this._xslSrc = new StreamSource(xslReader);
        this._transformerParams = transformerParams;
        this._initTransformer();
    }

    public XSLTransformer(InputSource saxInputSrc, Properties transformerParams) throws TransformerConfigurationException {
        this._xslSrc = new SAXSource(saxInputSrc);
        this._transformerParams = transformerParams;
        this._initTransformer();
    }

    public XSLTransformer(XMLReader saxXMLReader, InputSource saxInputSrc, Properties transformerParams) throws TransformerConfigurationException {
        this._xslSrc = new SAXSource(saxXMLReader, saxInputSrc);
        this._transformerParams = transformerParams;
        this._initTransformer();
    }

    public XSLTransformer(Node node, Properties transformerParams) throws TransformerConfigurationException {
        this._xslSrc = new DOMSource(node);
        this._transformerParams = transformerParams;
        this._initTransformer();
    }

    private void _initTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this._transformer = transformerFactory.newTransformer(this._xslSrc);
        if (this._transformerParams != null) {
            for (Map.Entry<Object, Object> me : this._transformerParams.entrySet()) {
                this._transformer.setParameter((String)me.getKey(), me.getValue());
            }
        }
    }

    public void applyToXMLGeneratingStream(InputStream xmlIS, OutputStream xmlOS) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlIS);
            StreamResult res = new StreamResult(xmlOS);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlIS != null) {
                    xmlIS.close();
                }
                if (xmlOS != null) {
                    xmlOS.flush();
                    xmlOS.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void applyToXMLGeneratingStream(InputStream xmlIS, Writer xmlWriter) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlIS);
            StreamResult res = new StreamResult(xmlWriter);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlIS != null) {
                    xmlIS.close();
                }
                if (xmlWriter != null) {
                    xmlWriter.flush();
                    xmlWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void applyToXMLGeneratingSAXEvents(InputStream xmlIS, ContentHandler saxContentHandler) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlIS);
            SAXResult res = new SAXResult(saxContentHandler);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlIS != null) {
                    xmlIS.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void applyToXMLGeneratingDOMNode(InputStream xmlIS, Node outNode) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlIS);
            DOMResult res = new DOMResult(outNode);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlIS != null) {
                    xmlIS.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void applyToXMLGeneratingStream(Reader xmlReader, OutputStream xmlOS) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlReader);
            StreamResult res = new StreamResult(xmlOS);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlReader != null) {
                    xmlReader.close();
                }
                if (xmlOS != null) {
                    xmlOS.flush();
                    xmlOS.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void applyToXMLGeneratingStream(Reader xmlReader, Writer xmlWriter) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlReader);
            StreamResult res = new StreamResult(xmlWriter);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlReader != null) {
                    xmlReader.close();
                }
                if (xmlWriter != null) {
                    xmlWriter.flush();
                    xmlWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void applyToXMLGeneratingSAXEvents(Reader xmlReader, ContentHandler saxContentHandler) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlReader);
            SAXResult res = new SAXResult(saxContentHandler);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlReader != null) {
                    xmlReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void applyToXMLGeneratingDOMNode(Reader xmlReader, Node outNode) throws TransformerException {
        try {
            StreamSource xmlSrc = new StreamSource(xmlReader);
            DOMResult res = new DOMResult(outNode);
            this._doTransform(xmlSrc, res);
        }
        finally {
            try {
                if (xmlReader != null) {
                    xmlReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void _doTransform(Source xmlSrc, Result res) throws TransformerException {
        if (this._transformer == null) {
            throw new TransformerException("NO se ha inicializado el transformer: revisar la llamada al constructor");
        }
        if (xmlSrc == null) {
            throw new TransformerException("NO se puede transformar: el xml origen es nulo: revisar la llamada a applyToXMLGeneratingStream");
        }
        if (res == null) {
            throw new TransformerException("NO se puede transformar el destino es nulo: revisar la llamada a applyToXMLGeneratingStream");
        }
        this._transformer.transform(xmlSrc, res);
    }
}

