/*
 * Decompiled with CFR 0.152.
 */
package r01f.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLStringSerializer {
    public static String writeDocument(Document doc, Charset outEncoding) {
        if (doc == null) {
            return null;
        }
        return XMLStringSerializer.writeNode(doc.getDocumentElement(), outEncoding);
    }

    public static String writeNode(Node beginNode, Charset outEncoding) {
        if (beginNode == null) {
            return null;
        }
        try {
            return XMLStringSerializer.writeOuterXML(beginNode, outEncoding);
        }
        catch (TransformerException tEx) {
            return "Error al pasar el nodo DOM a String XML: " + tEx.toString();
        }
    }

    public static String writeInnerXML(Node node, Charset outEncoding) throws TransformerException {
        StringBuilder innerXml = new StringBuilder();
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            int i = childNodes.getLength();
            int c = 0;
            while (c < i) {
                innerXml.append(XMLStringSerializer.writeOuterXML(childNodes.item(c), outEncoding));
                ++c;
            }
            return innerXml.toString();
        }
        return "";
    }

    public static String writeOuterXML(Node node, Charset outEncoding) throws TransformerException {
        if (node == null) {
            return null;
        }
        try {
            TransformerFactory fac = TransformerFactory.newInstance();
            Transformer tf = fac.newTransformer();
            Properties tfProps = new Properties();
            if (outEncoding != null) {
                tfProps.setProperty("encoding", outEncoding.name());
            }
            tfProps.setProperty("indent", "yes");
            tf.setOutputProperties(tfProps);
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource src = new DOMSource(node);
            StringWriter w = new StringWriter();
            StreamResult rslt = new StreamResult(w);
            tf.transform(src, rslt);
            return w.toString();
        }
        catch (TransformerFactoryConfigurationError tfCfgEx) {
            throw new TransformerException(tfCfgEx);
        }
        catch (TransformerConfigurationException tfCfgEx) {
            throw new TransformerException(tfCfgEx);
        }
        catch (IllegalArgumentException illArgEx) {
            throw new TransformerException(illArgEx);
        }
    }

    public static String beautfyXMLString(String notFormatedXMLString) throws TransformerException {
        return XMLStringSerializer.beautfyXMLString(notFormatedXMLString, Charset.defaultCharset(), Charset.defaultCharset());
    }

    public static String beautfyXMLString(String notFormatedXMLString, Charset inputEncoding, Charset outEncoding) throws TransformerException {
        Document doc = null;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setIgnoringComments(true);
        dfactory.setNamespaceAware(true);
        try {
            InputSource is = new InputSource(new ByteArrayInputStream(notFormatedXMLString.getBytes(inputEncoding)));
            doc = dfactory.newDocumentBuilder().parse(is);
        }
        catch (ParserConfigurationException pcEx) {
            throw new TransformerException("Error en la configuracin del parser XML: " + pcEx.toString());
        }
        catch (SAXException saxEx) {
            throw new TransformerException("Error en el parseo SAX: " + saxEx.toString());
        }
        catch (IOException ioEx) {
            throw new TransformerException("Error en el parseo SAX: " + ioEx.toString());
        }
        String salida = XMLStringSerializer.writeDocument(doc, outEncoding);
        return salida;
    }
}

