/*
 * Decompiled with CFR 0.152.
 */
package r01f.xml;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import r01f.resources.ResourcesLoader;

public class XMLDocumentBuilder {
    private ResourcesLoader _resourcesLoader;

    public XMLDocumentBuilder(ResourcesLoader resLoader) {
        this._resourcesLoader = resLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document buildXMLDOM(String xmlFilePath, String ... ignoredEntities) throws SAXException {
        try {
            InputStream xmlIS = this._resourcesLoader.getInputStream(xmlFilePath, true);
            try {
                if (xmlIS == null) throw new FileNotFoundException("NO se ha podido cargar el xml desde " + xmlFilePath + ": el recurso NO existe");
                Document document = XMLDocumentBuilder.buildXMLDOM(xmlIS, ignoredEntities);
                return document;
            }
            finally {
                if (Collections.singletonList(xmlIS).get(0) != null) {
                    xmlIS.close();
                }
            }
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }

    public static Document buildXMLDOM(InputStream xmlIs, final String ... ignoredEntities) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String key;
                    String string = key = publicId != null ? String.valueOf(publicId) + "." + systemId : systemId;
                    if (this._isIgnoredExternalEntity(key)) {
                        return new InputSource(new ByteArrayInputStream("".getBytes()));
                    }
                    return null;
                }

                private boolean _isIgnoredExternalEntity(String key) {
                    if (ignoredEntities != null) {
                        int i = 0;
                        while (i < ignoredEntities.length) {
                            if (ignoredEntities[i].equals(key)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    return false;
                }
            });
            return builder.parse(xmlIs);
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException(pcEx);
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }
}

