/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types.collections;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class SetOperations<T> {
    Set<T>[] _sets;
    Comparator<? super T> _comparator;

    public SetOperations(Set<T> ... sets) {
        this._sets = sets;
    }

    public SetOperations<T> usingComparator(Comparator<T> comp) {
        this._comparator = comp;
        return this;
    }

    public Set<T> intersection() {
        if (this._sets == null || this._sets.length == 0) {
            return Sets.newHashSet();
        }
        SetView intersect = new SetView<T>(){

            @Override
            public Iterator<T> iterator() {
                return SetOperations.this._sets[0].iterator();
            }

            @Override
            public int size() {
                return SetOperations.this._sets[0].size();
            }

            @Override
            public boolean isEmpty() {
                return SetOperations.this._sets[0].isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return SetOperations.this._sets[0].contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return SetOperations.this._sets[0].containsAll(collection);
            }
        };
        int i = 1;
        while (i < this._sets.length) {
            if ((intersect = this._intersection(intersect, this._sets[i])).size() == 0) break;
            ++i;
        }
        return intersect;
    }

    public Set<T> union() {
        if (this._sets == null || this._sets.length == 0) {
            return Sets.newHashSet();
        }
        SetView union = new SetView<T>(){

            @Override
            public Iterator<T> iterator() {
                return SetOperations.this._sets[0].iterator();
            }

            @Override
            public int size() {
                return SetOperations.this._sets[0].size();
            }

            @Override
            public boolean isEmpty() {
                return SetOperations.this._sets[0].isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return SetOperations.this._sets[0].contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return SetOperations.this._sets[0].containsAll(collection);
            }
        };
        int i = 1;
        while (i < this._sets.length) {
            union = this._union(this._sets[i], union);
            ++i;
        }
        return union;
    }

    public Set<T> difference() {
        return Sets.difference(this.union(), this.intersection());
    }

    private SetView<T> _intersection(final Set<T> set1, final Set<T> set2) {
        final InSetPredicate inSet2 = new InSetPredicate(set2);
        return new SetView<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(set1.iterator(), (Predicate)inSet2);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object object) {
                return set1.contains(object) && set2.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set1.containsAll(collection) && set2.containsAll(collection);
            }
        };
    }

    private SetView<T> _union(final Set<T> set1, Set<T> set2) {
        Sets.SetView set2minus1 = Sets.difference(set2, set1);
        return new SetView<T>((Set)set2minus1, set2){
            private final /* synthetic */ Set val$set2minus1;
            private final /* synthetic */ Set val$set2;
            {
                this.val$set2minus1 = set2;
                this.val$set2 = set3;
            }

            @Override
            public int size() {
                return set1.size() + this.val$set2minus1.size();
            }

            @Override
            public boolean isEmpty() {
                return set1.isEmpty() && this.val$set2.isEmpty();
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.unmodifiableIterator((Iterator)Iterators.concat(set1.iterator(), this.val$set2minus1.iterator()));
            }

            @Override
            public boolean contains(Object object) {
                return set1.contains(object) || this.val$set2.contains(object);
            }

            @Override
            public <S extends Set<T>> S copyInto(S set) {
                set.addAll(set1);
                set.addAll(this.val$set2);
                return set;
            }

            @Override
            public ImmutableSet<T> immutableCopy() {
                return new ImmutableSet.Builder().addAll((Iterable)set1).addAll((Iterable)this.val$set2).build();
            }
        };
    }

    private final class InSetPredicate
    implements Predicate<T> {
        private Set<T> _theSet;

        public InSetPredicate(Set<T> set) {
            this._theSet = set;
        }

        public boolean apply(T el) {
            try {
                boolean inCol = false;
                if (SetOperations.this._comparator != null) {
                    for (Object currEl : this._theSet) {
                        if (SetOperations.this._comparator.compare(currEl, el) != 0) continue;
                        inCol = true;
                        break;
                    }
                } else {
                    inCol = this._theSet.contains(el);
                }
                return inCol;
            }
            catch (NullPointerException nullEx) {
                return false;
            }
            catch (ClassCastException castEx) {
                return false;
            }
        }
    }

    public abstract class SetView<E>
    extends AbstractSet<E> {
        SetView() {
        }

        public ImmutableSet<E> immutableCopy() {
            return ImmutableSet.copyOf((Collection)this);
        }

        public <S extends Set<E>> S copyInto(S set) {
            set.addAll(this);
            return set;
        }
    }
}

