/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types.collections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import r01f.util.types.collections.CollectionUtils;

public class MapsWrappers {

    public static class MapDifferences<K, V> {
        private final MapDifference<K, V> _diferences;

        public MapDifferences(MapDifference<K, V> theDifferences) {
            this._diferences = theDifferences;
        }

        public Map<K, V> entriesInCommonWith() {
            if (this._diferences == null) {
                return null;
            }
            return this._diferences.entriesInCommon();
        }

        public Map<K, V> deletedEntries() {
            if (this._diferences == null) {
                return null;
            }
            return this._diferences.entriesOnlyOnLeft();
        }

        public Map<K, V> newEntries() {
            if (this._diferences == null) {
                return null;
            }
            return this._diferences.entriesOnlyOnRight();
        }
    }

    public static class WrappedMap<K, V> {
        Map<K, V> _theMap;

        public WrappedMap(Map<K, V> newMap) {
            this._theMap = newMap;
        }

        public Map<K, V> map() {
            return this._theMap;
        }

        void set(Map<K, V> newMap) {
            this._theMap = newMap;
        }

        public Map.Entry<K, V> pickOneAndOnlyEntry() {
            if (CollectionUtils.isNullOrEmpty(this._theMap)) {
                return null;
            }
            if (this._theMap.size() > 1) {
                throw new IllegalStateException("The one and only element of a map has been requested but the map has MORE THAN ONE element");
            }
            return this.pickOneEntry();
        }

        public V pickOneAndOnlyEntryValue() {
            Map.Entry<K, V> me = this.pickOneEntry();
            return me != null ? (V)me.getValue() : null;
        }

        public K pickOneAndOnlyEntryKey() {
            Map.Entry<K, V> me = this.pickOneEntry();
            return me != null ? (K)me.getKey() : null;
        }

        public Map.Entry<K, V> pickOneEntry() {
            if (this._theMap == null) {
                return null;
            }
            Map.Entry<K, V> outEntry = null;
            Iterator<Map.Entry<K, V>> iterator = this._theMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<K, V> me;
                outEntry = me = iterator.next();
            }
            return outEntry;
        }

        public V pickOneEntryValue() {
            Map.Entry<K, V> me = this.pickOneEntry();
            return me != null ? (V)me.getValue() : null;
        }

        public K pickOneEntryKey() {
            Map.Entry<K, V> me = this.pickOneEntry();
            return me != null ? (K)me.getKey() : null;
        }

        public MapDifferences<K, V> compareWith(Map<K, V> otherMap) {
            if (this._theMap == null || otherMap == null) {
                return new MapDifferences(null);
            }
            return new MapDifferences(Maps.difference(this._theMap, otherMap));
        }

        public <W> WrappedMap<K, W> transform(Function<? super V, W> function) {
            Map transformedMap = Maps.transformValues(this._theMap, function);
            WrappedMap<K, V> transformedMapWrapped = new WrappedMap<K, V>(transformedMap);
            return transformedMapWrapped;
        }

        public WrappedMap<K, V> filter(Predicate<? super V> predicate) {
            Map filteredMap = Maps.filterValues(this._theMap, predicate);
            WrappedMap<K, V> filteredMapWrapped = new WrappedMap<K, V>(filteredMap);
            return filteredMapWrapped;
        }
    }
}

