/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types.collections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import r01f.generics.TypeRef;
import r01f.reflection.fluent.FluentReflection;
import r01f.util.types.collections.CollectionUtils;

public class CollectionWrappers {
    static <T extends Comparable<? super T>> Collection<T> _sort(Collection<T> unorderedCollection) {
        return CollectionWrappers._sort(unorderedCollection, Locale.getDefault());
    }

    static <T extends Comparable<? super T>> Collection<T> _sort(Collection<T> unorderedCollection, String langLocale) {
        Collator collator = Collator.getInstance(new Locale(langLocale));
        return CollectionWrappers._sort(unorderedCollection, collator);
    }

    static <T extends Comparable<? super T>> Collection<T> _sort(Collection<T> unorderedCollecion, Locale locale) {
        Collator collator = Collator.getInstance(locale);
        return CollectionWrappers._sort(unorderedCollecion, collator);
    }

    static <T extends Comparable<? super T>> Collection<T> _sort(Collection<T> unorderedCollection, Collator collator) {
        if (unorderedCollection == null || unorderedCollection.isEmpty()) {
            return null;
        }
        return Ordering.from((Comparator)collator).sortedCopy(unorderedCollection);
    }

    static <T extends Comparable<? super T>> List<T> _sort(Collection<T> unorderedCollection, Comparator<? super T> comparator) {
        if (unorderedCollection == null) {
            return null;
        }
        Collator theComp = comparator;
        if (theComp == null) {
            theComp = Collator.getInstance(Locale.getDefault());
        }
        return Ordering.from(theComp).sortedCopy(unorderedCollection);
    }

    static <K, V> Map<K, V> _toMap(Collection<V> theCollection, String oidFieldName) {
        String theOidFieldName = oidFieldName;
        if (theOidFieldName == null) {
            theOidFieldName = "key";
        }
        HashMap outMap = null;
        if (theCollection != null) {
            outMap = new HashMap(theCollection.size());
            for (V currObj : theCollection) {
                Object currObjOid = FluentReflection.field(theOidFieldName).ofType(new TypeRef<K>(){}).in(currObj).get();
                outMap.put(currObjOid, currObj);
            }
        }
        return outMap;
    }

    public static class WrappedCollection<T> {
        Collection<T> _theCol;

        public WrappedCollection(Collection<T> newCollection) {
            this._theCol = newCollection;
        }

        public Collection<T> collection() {
            return this._theCol;
        }

        public <K> Map<K, T> toMapIndexingByField(String oidFieldName) {
            return CollectionWrappers._toMap(this._theCol, oidFieldName);
        }

        public <F> WrappedCollection<F> transform(Function<? super T, F> function) {
            Collection transformedList = Collections2.transform(this._theCol, function);
            WrappedCollection<T> transformedListWrapped = new WrappedCollection<T>(transformedList);
            return transformedListWrapped;
        }

        public WrappedCollection<T> filter(Predicate<? super T> predicate) {
            Set filteredSet = Sets.filter((Set)Sets.newLinkedHashSet(this._theCol), predicate);
            ArrayList list = Lists.newArrayList((Iterable)filteredSet);
            WrappedCollection<T> filteredListWrapped = new WrappedCollection<T>(list);
            return filteredListWrapped;
        }

        public T pickOneAndOnlyElement() {
            if (CollectionUtils.isNullOrEmpty(this._theCol)) {
                return null;
            }
            if (this._theCol.size() > 1) {
                throw new IllegalStateException("The one and only element of a collection has been requested but the collection has MORE THAN ONE element");
            }
            return this.pickOneElement();
        }

        public T pickOneElement() {
            if (CollectionUtils.isNullOrEmpty(this._theCol)) {
                return null;
            }
            T outEl = null;
            Iterator<T> iterator = this._theCol.iterator();
            if (iterator.hasNext()) {
                T el = iterator.next();
                outEl = el;
            }
            return outEl;
        }

        public String toStringCommaSeparated() {
            if (CollectionUtils.isNullOrEmpty(this._theCol)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            Iterator<T> it = this._theCol.iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }

    public static class WrappedSortableCollection<T extends Comparable<? super T>>
    extends WrappedCollection<T> {
        public WrappedSortableCollection(Collection<T> newCol) {
            super(newCol);
        }

        public WrappedSortableCollection<T> sort() {
            this._theCol = CollectionWrappers._sort(this._theCol);
            return this;
        }

        public WrappedSortableCollection<T> sort(Locale loc) {
            this._theCol = CollectionWrappers._sort(this._theCol, loc);
            return this;
        }

        public WrappedSortableCollection<T> sort(String langLoc) {
            this._theCol = CollectionWrappers._sort(this._theCol, langLoc);
            return this;
        }

        public WrappedSortableCollection<T> sort(Collator collator) {
            this._theCol = CollectionWrappers._sort(this._theCol, collator);
            return this;
        }

        public WrappedSortableCollection<T> sort(Comparator<T> comp) {
            this._theCol = CollectionWrappers._sort(this._theCol, comp);
            return this;
        }
    }
}

