/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import r01f.reflection.ReflectionUtils;
import r01f.util.types.collections.CollectionWrappers;
import r01f.util.types.collections.MapsWrappers;
import r01f.util.types.collections.SetOperations;

public class CollectionUtils {
    public static <T> CollectionWrappers.WrappedCollection<T> of(Collection<T> aCol) {
        return new CollectionWrappers.WrappedCollection<T>(aCol);
    }

    public static <T extends Comparable<? super T>> CollectionWrappers.WrappedSortableCollection<T> ofSortable(Collection<T> aCol) {
        return new CollectionWrappers.WrappedSortableCollection<T>(aCol);
    }

    public static <T> CollectionWrappers.WrappedCollection<T> of(T ... objCol) {
        ArrayList theList = Lists.newArrayList((Object[])objCol);
        return new CollectionWrappers.WrappedCollection(theList);
    }

    public static <T extends Comparable<? super T>> CollectionWrappers.WrappedSortableCollection<T> ofSortable(T ... objCol) {
        ArrayList theList = Lists.newArrayList((Object[])objCol);
        return new CollectionWrappers.WrappedSortableCollection(theList);
    }

    public static <K, V> MapsWrappers.WrappedMap<K, V> of(Map<K, V> aMap) {
        return new MapsWrappers.WrappedMap<K, V>(aMap);
    }

    public static <T> SetOperations<T> setOperationsOf(Set<T> ... sets) {
        return new SetOperations<T>(sets);
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Map<?, ?> theMap) {
        return theMap == null || theMap.size() == 0;
    }

    public static boolean isNullOrEmpty(Multimap<?, ?> theMultimap) {
        return theMultimap == null || theMultimap.size() == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> theCol) {
        return theCol == null || theCol.size() == 0;
    }

    public static boolean isArray(Class<?> type) {
        return type.isArray();
    }

    public static boolean isObjectsArray(Class<?> type) {
        return type.isArray() && !type.getComponentType().isPrimitive();
    }

    public static boolean isMap(Class<?> type) {
        return ReflectionUtils.isImplementing(type, Map.class);
    }

    public static boolean isCollection(Class<?> type) {
        return ReflectionUtils.isImplementing(type, Collection.class);
    }

    public static Class<?> getCollectionType(Class<?> type) {
        Class colType = null;
        if (CollectionUtils.isMap(type)) {
            colType = Map.class;
        } else if (CollectionUtils.isCollection(type)) {
            colType = List.class;
        }
        return colType;
    }

    public static interface CollectionMutatorMethods<V> {
        public boolean add(V var1);

        public boolean addAll(Collection<? extends V> var1);

        public void clear();

        public boolean remove(Object var1);

        public boolean removeAll(Collection<?> var1);

        public boolean retainAll(Collection<?> var1);
    }

    public static interface MapMutatorMethods<K, V> {
        public void clear();

        public V put(K var1, V var2);

        public void putAll(Map<? extends K, ? extends V> var1);

        public V remove(Object var1);
    }
}

