/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types.collections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;

public class ArrayFormatter {
    private static final String NULL = "null";

    public static ArrayFormatter instance() {
        return new ArrayFormatter();
    }

    public String format(Object o) {
        if (o == null) {
            return null;
        }
        if (!CollectionUtils.isArray(o.getClass())) {
            return null;
        }
        if (CollectionUtils.isObjectsArray(o.getClass())) {
            return this._formatObjectsArray((Object[])o);
        }
        return ArrayFormatter._formatPrimitivesArray(o);
    }

    private String _formatObjectsArray(Object[] objsArray) {
        int arrayLength = objsArray.length;
        if (arrayLength == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(20 * (arrayLength - 1));
        this._deepToString(objsArray, buffer, new HashSet<Object[]>());
        return buffer.toString();
    }

    private void _deepToString(Object[] objsArray, StringBuilder buffer, Set<Object[]> alreadyFormatted) {
        if (objsArray == null) {
            buffer.append(NULL);
            return;
        }
        alreadyFormatted.add(objsArray);
        buffer.append('[');
        int length = objsArray.length;
        int i = 0;
        while (i < length) {
            Object element;
            if (i != 0) {
                buffer.append(", ");
            }
            if ((element = objsArray[i]) == null) {
                buffer.append(NULL);
            } else if (!CollectionUtils.isArray(element.getClass())) {
                buffer.append(Strings.quote(element.toString()));
            } else if (!CollectionUtils.isObjectsArray(element.getClass())) {
                buffer.append(ArrayFormatter._formatPrimitivesArray(element));
            } else if (alreadyFormatted.contains(element)) {
                buffer.append("[...]");
            } else {
                this._deepToString((Object[])element, buffer, alreadyFormatted);
            }
            ++i;
        }
        buffer.append(']');
        alreadyFormatted.remove(objsArray);
    }

    private static String _formatPrimitivesArray(Object primitivesArray) {
        Class<?> elementType = primitivesArray.getClass().getComponentType();
        if (elementType.equals(Boolean.TYPE)) {
            return Arrays.toString((boolean[])primitivesArray);
        }
        if (elementType.equals(Character.TYPE)) {
            return Arrays.toString((char[])primitivesArray);
        }
        if (elementType.equals(Byte.TYPE)) {
            return Arrays.toString((byte[])primitivesArray);
        }
        if (elementType.equals(Short.TYPE)) {
            return Arrays.toString((short[])primitivesArray);
        }
        if (elementType.equals(Integer.TYPE)) {
            return Arrays.toString((int[])primitivesArray);
        }
        if (elementType.equals(Long.TYPE)) {
            return Arrays.toString((long[])primitivesArray);
        }
        if (elementType.equals(Float.TYPE)) {
            return Arrays.toString((float[])primitivesArray);
        }
        if (elementType.equals(Double.TYPE)) {
            return Arrays.toString((double[])primitivesArray);
        }
        throw new IllegalArgumentException(Strings.of((CharSequence)"<").add((CharSequence)primitivesArray.toString()).add((CharSequence)"> is not an array of primitives").asString());
    }
}

