/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang.StringUtils;
import r01f.encoding.TextEncoder;
import r01f.resources.ResourcesLoader;
import r01f.resources.ResourcesLoaderFactory;
import r01f.util.types.StringEncodeUtils;
import r01f.util.types.StringPersistenceUtils;
import r01f.util.types.StringXMLEncodeUtils;

public class Strings {
    public static StringWrapper create() {
        return new StringWrapper((CharSequence)"");
    }

    public static StringWrapper create(int length) {
        return new StringWrapper(length);
    }

    public static StringWrapper createFillingWithChar(char theChar, int size) {
        String theString = StringUtils.rightPad((String)"", (int)size, (char)theChar);
        return new StringWrapper((CharSequence)theString);
    }

    public static StringWrapper of(CharSequence string) {
        return new StringWrapper(string);
    }

    public static StringWrapper of(CharSequence ... strings) {
        return new StringWrapper(strings);
    }

    public static StringWrapper load(ResourcesLoader loader, String filePath) throws IOException {
        ResourcesLoader theLoader = loader == null ? ResourcesLoaderFactory.DEFAULT_RESOURCES_LOADER : loader;
        String string = StringPersistenceUtils.load(theLoader, filePath);
        return new StringWrapper((CharSequence)string);
    }

    public static StringWrapper load(File f) throws IOException {
        String string = StringPersistenceUtils.load(f);
        return new StringWrapper((CharSequence)string);
    }

    public static StringWrapper load(InputStream is) throws IOException {
        String string = StringPersistenceUtils.load(is);
        return new StringWrapper((CharSequence)string);
    }

    public static StringWrapper load(Reader r) throws IOException {
        String string = StringPersistenceUtils.load(r);
        return new StringWrapper((CharSequence)string);
    }

    public static StringWrapper load(String filePath) throws IOException {
        String string = StringPersistenceUtils.load(new File(filePath));
        return new StringWrapper((CharSequence)string);
    }

    public static StringBuffer customize(CharSequence strToCustomize, CharSequence ... vars) {
        if (strToCustomize == null) {
            return null;
        }
        CharSequence[] theVars = vars != null ? vars : new CharSequence[]{};
        Pattern p = Pattern.compile("\\{\\}");
        Matcher m = p.matcher(strToCustomize);
        StringBuffer sb = new StringBuffer(strToCustomize.length() + 10 * theVars.length);
        int i = 0;
        while (m.find()) {
            String replacement = i < theVars.length ? (theVars[i] != null ? theVars[i].toString() : "{}") : "{}";
            m.appendReplacement(sb, replacement);
            if (++i != theVars.length) continue;
            i = 0;
        }
        m.appendTail(sb);
        return sb;
    }

    public static boolean isNullOrEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        boolean isEmpty = true;
        int i = 0;
        while (i < str.length()) {
            if (!Character.isWhitespace(str.charAt(i))) {
                isEmpty = false;
                break;
            }
            ++i;
        }
        return isEmpty;
    }

    public static boolean isNullOrEmpty(char[] chars) {
        if (chars == null || chars.length == 0) {
            return true;
        }
        boolean isEmpty = true;
        int i = 0;
        while (i < chars.length) {
            if (!Character.isWhitespace(chars[i])) {
                isEmpty = false;
                break;
            }
            ++i;
        }
        return isEmpty;
    }

    public static String concat(CharSequence ... strs) {
        if (strs == null || strs.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        CharSequence[] charSequenceArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence currSeq = charSequenceArray[n2];
            sb.append(currSeq);
            ++n2;
        }
        return sb.toString();
    }

    public static String concat(String ... strs) {
        if (strs == null || strs.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }

    public static String quote(String s) {
        return s != null ? Strings.concat("'", s, "'") : null;
    }

    public static void main(String[] args) {
        try {
            String a = Strings.of((CharSequence)"a").windows1252ToIso8859().asXml().decodeUTFDoubleByteCharsFromEntities().filterInvalidChars().toString();
            System.out.println(a);
            String b = Strings.load(new File("/a")).encode(Charset.forName("UTF-8")).asString();
            System.out.println(b);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public static class SplitterWrapper {
        private CharSequence _str;
        private Splitter _splitter;

        public SplitterWrapper(Splitter splitter, CharSequence str) {
            this._str = str;
            this._splitter = splitter;
        }

        public int indexOf(String element) {
            int outIndex = -1;
            Iterable<String> it = this.split();
            if (it != null) {
                int i = 0;
                for (String s : it) {
                    if (s.equals(element)) {
                        outIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            return outIndex;
        }

        public Iterable<String> split() {
            if (this._str == null) {
                return null;
            }
            return this._splitter.split(this._str);
        }

        public StringWrapper group(int groupNum) {
            String outGroup = null;
            Iterable<String> ib = this.split();
            if (ib != null && groupNum >= 0) {
                int i = 1;
                Iterator<String> it = ib.iterator();
                if (it.hasNext()) {
                    do {
                        outGroup = it.next();
                    } while (++i <= groupNum && it.hasNext());
                }
            }
            return new StringWrapper((CharSequence)outGroup);
        }

        public SplitterWrapper limit(int limit) {
            this._splitter = this._splitter.limit(limit);
            return this;
        }

        public SplitterWrapper omitEmptyStrings() {
            this._splitter = this._splitter.omitEmptyStrings();
            return this;
        }

        public SplitterWrapper trimResults() {
            this._splitter = this._splitter.trimResults();
            return this;
        }

        public SplitterWrapper trimResults(CharMatcher trimmer) {
            this._splitter = this._splitter.trimResults(trimmer);
            return this;
        }
    }

    public static class StringWrapper
    implements CharSequence {
        protected StringBuilder string;

        StringWrapper(int size) {
            this._createBuffer(size);
        }

        StringWrapper(int size, CharSequence theString) {
            this._createBuffer(size);
            this.string.append(theString);
        }

        StringWrapper(CharSequence theString) {
            if (theString == null) {
                this._createBuffer(0);
            } else {
                this._createBuffer(theString.length());
                this.string.append(theString);
            }
        }

        StringWrapper(CharSequence ... theStrings) {
            if (theStrings != null && theStrings.length > 0) {
                CharSequence cs;
                int totalLength = 0;
                CharSequence[] charSequenceArray = theStrings;
                int n = theStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    cs = charSequenceArray[n2];
                    totalLength += cs != null ? cs.length() : 0;
                    ++n2;
                }
                this._createBuffer(totalLength);
                charSequenceArray = theStrings;
                n = theStrings.length;
                n2 = 0;
                while (n2 < n) {
                    cs = charSequenceArray[n2];
                    this.string.append(cs);
                    ++n2;
                }
            }
        }

        private void _createBuffer(int size) {
            this.string = size > 0 ? new StringBuilder(size) : new StringBuilder();
        }

        @Override
        public char charAt(int index) {
            return this.string.charAt(index);
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.string.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.string.toString();
        }

        public StringWrapper format(Locale l, Object args) {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(String.format(l, this.asString(), args));
            return this;
        }

        public StringWrapper format(Object args) {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(String.format(this.asString(), args));
            return this;
        }

        public String asString() {
            return this.toString();
        }

        public byte[] getBytes() {
            return this.string.toString().getBytes(Charset.defaultCharset());
        }

        public byte[] getBytes(Charset charset) {
            return this.string.toString().getBytes(charset);
        }

        public StringBuilder asStringBuilder() {
            return this.string;
        }

        public StringBuffer asStringBuffer() {
            return new StringBuffer(this.string);
        }

        public char[] asCharArray() {
            return this.string.toString().toCharArray();
        }

        public InputStream asInputStream() {
            return this.asInputStream(Charset.defaultCharset());
        }

        public InputStream asInputStream(Charset charset) {
            return new ByteArrayInputStream(this.asString().getBytes(charset));
        }

        public Reader asReader() {
            return new StringReader(this.asString());
        }

        public StringXMLOpsWrapper asXml() {
            return new StringXMLOpsWrapper((CharSequence)this.string);
        }

        public StringWrapper urlEncode() throws EncoderException {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(StringEncodeUtils.urlEncode(this.string));
            return this;
        }

        public StringWrapper urlDecode() throws DecoderException {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(StringEncodeUtils.urlDecode(this.string));
            return this;
        }

        public StringWrapper encode(Charset encoding) {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(StringEncodeUtils.encode(this.string, encoding));
            return this;
        }

        public StringWrapper encodeUTF8() {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(StringEncodeUtils.encodeUTF(this.string));
            return this;
        }

        public StringWrapper encodeISO8859() {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(StringEncodeUtils.encodeISO8859(this.string));
            return this;
        }

        public StringWrapper windows1252ToIso8859() {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(StringEncodeUtils.windows1252ToIso8859(this.string));
            return this;
        }

        public StringWrapper filterAndReplaceChars(char[] charsToFilter, String[] charsFiltered) {
            if (this.string == null) {
                return this;
            }
            this.string = new StringBuilder(StringEncodeUtils.filterAndReplaceChars(this.string, charsToFilter, charsFiltered));
            return this;
        }

        public StringWrapper removeAccents() {
            if (this.string == null) {
                return this;
            }
            String normalized = Normalizer.normalize(this.string, Normalizer.Form.NFD);
            Pattern pattern = Pattern.compile("[^\\p{ASCII}+]");
            this.string = new StringBuilder(pattern.matcher(normalized).replaceAll(""));
            return this;
        }

        public StringWrapper replaceAll(String regex, String replacement) {
            if (this.string == null) {
                return this;
            }
            String newStr = this.string.toString().replaceAll(regex, replacement);
            this.string = new StringBuilder(newStr);
            return this;
        }

        public void save(File f) throws IOException {
            StringPersistenceUtils.save((CharSequence)this.string, f);
        }

        public void save(String filePath) throws IOException {
            StringPersistenceUtils.save((CharSequence)this.string, filePath);
        }

        public StringWrapper add(CharSequence other) {
            if (other != null) {
                this.string.append(other);
            }
            return this;
        }

        public StringWrapper addCustomized(CharSequence other, CharSequence ... vars) {
            StringBuffer customized = Strings.customize(other, vars);
            return customized != null ? this.add((CharSequence)customized) : this;
        }

        public StringWrapper customizeWith(CharSequence ... vars) {
            StringBuffer customized = Strings.customize(this.string, vars);
            if (customized != null) {
                this.string = new StringBuilder(customized);
            }
            return this;
        }

        public StringWrapper customizeWith(Object ... vars) {
            if (vars == null) {
                return this.customizeWith((CharSequence[])null);
            }
            CharSequence[] varsAsString = new String[vars.length];
            int i = 0;
            while (i < vars.length) {
                varsAsString[i] = vars[i].toString();
                ++i;
            }
            return this.customizeWith(varsAsString);
        }

        public StringWrapper add(Number num) {
            this.string.append(num);
            return this;
        }

        public StringWrapper add(char[] other) {
            this.string.append(other);
            return this;
        }

        public StringWrapper add(CharSequence other, int start, int end) {
            this.string.append(other, start, end);
            return this;
        }

        public StringWrapper add(char[] other, int start, int end) {
            this.string.append(other, start, end);
            return this;
        }

        public StringWrapper addLine(CharSequence line) {
            this.string.append(line);
            this.string.append("\r\n");
            return this;
        }

        public StringWrapper addQuoted(CharSequence other) {
            this.string.append("\"").append(other).append("\"");
            return this;
        }

        public StringWrapper add(CharSequence ... others) {
            if (others != null && others.length > 0) {
                CharSequence[] charSequenceArray = others;
                int n = others.length;
                int n2 = 0;
                while (n2 < n) {
                    CharSequence cs = charSequenceArray[n2];
                    this.string.append(cs);
                    ++n2;
                }
            }
            return this;
        }

        public StringWrapper rightPad(char c, int length) {
            if (this.string.length() <= length) {
                String paddedStr = StringUtils.rightPad((String)this.string.toString(), (int)length, (char)c);
                this.string.delete(0, this.string.length() - 1);
                this.string = this.string.append(paddedStr);
            }
            return this;
        }

        public StringWrapper leftPad(char c, int length) {
            if (this.string.length() <= length) {
                String paddedStr = StringUtils.leftPad((String)this.string.toString(), (int)length, (char)c);
                this.string.delete(0, this.string.length() - 1);
                this.string = this.string.append(paddedStr);
            }
            return this;
        }

        public StringWrapper quote() {
            this.quote("\"");
            return this;
        }

        public StringWrapper quote(String q) {
            this.string.insert(0, q);
            this.string.append(q);
            return this;
        }

        public StringWrapper trim() {
            this.string = new StringBuilder(this.string.toString().trim());
            return this;
        }

        public StringWrapper encodeUsing(TextEncoder encoder) {
            if (encoder != null) {
                this.string = new StringBuilder(encoder.encode(this.string));
            }
            return this;
        }

        public StringWrapper decodeUsing(TextEncoder decoder) {
            if (decoder != null) {
                this.string = new StringBuilder(decoder.decode(this.string));
            }
            return this;
        }

        public SplitterWrapper splitter(int chunksLength) {
            return new SplitterWrapper(Splitter.fixedLength((int)chunksLength), this.string);
        }

        public SplitterWrapper splitter(char separator) {
            return new SplitterWrapper(Splitter.on((char)separator), this.string);
        }

        public SplitterWrapper splitter(CharMatcher separatorMatcher) {
            return new SplitterWrapper(Splitter.on((CharMatcher)separatorMatcher), this.string);
        }

        public SplitterWrapper splitter(String separator) {
            return new SplitterWrapper(Splitter.on((String)separator), this.string);
        }

        public SplitterWrapper splitter(Pattern separatorPattern) {
            return new SplitterWrapper(Splitter.on((Pattern)separatorPattern), this.string);
        }

        public Matcher matcher(String regEx) {
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(this.string);
            return m;
        }
    }

    public static class StringXMLOpsWrapper
    extends StringWrapper {
        StringXMLOpsWrapper(CharSequence theString) {
            super(theString);
        }

        public StringXMLOpsWrapper filterInvalidChars() {
            this.string = new StringBuilder(StringXMLEncodeUtils.filterInvalidChars(this.string));
            return this;
        }

        public StringXMLOpsWrapper encodeUTFDoubleByteCharsAsEntities() {
            this.string = new StringBuilder(StringXMLEncodeUtils.encodeUTFDoubleByteCharsAsEntities(this.string));
            return this;
        }

        public StringXMLOpsWrapper encodeUTFDoubleByteCharsAndQuoutesAsEntities() {
            this.string = new StringBuilder(StringXMLEncodeUtils.encodeUTFDoubleByteCharsAndQuoutesAsEntities(this.string));
            return this;
        }

        public StringXMLOpsWrapper decodeUTFDoubleByteCharsFromEntities() {
            this.string = new StringBuilder(StringXMLEncodeUtils.decodeUTFDoubleByteCharsFromEntities(this.string));
            return this;
        }
    }
}

