/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StringXMLEncodeUtils {
    StringXMLEncodeUtils() {
    }

    public static boolean isLegalChar(int theChar) {
        return theChar == 9 || theChar == 10 || theChar == 13 || theChar >= 32 && theChar <= 55295 || theChar >= 57344 && theChar <= 65533 || theChar >= 65536 && theChar <= 0x10FFFF;
    }

    public static CharSequence filterInvalidChars(CharSequence str) {
        StringBuffer outResp = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            char code = str.charAt(i);
            if (StringXMLEncodeUtils.isLegalChar(code)) {
                outResp.append(str.charAt(i));
            }
            ++i;
        }
        return outResp.toString();
    }

    public static CharSequence encodeUTFDoubleByteCharsAsEntities(CharSequence str) {
        if (str == null) {
            return null;
        }
        StringBuilder outResp = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char code = str.charAt(i);
            if (StringXMLEncodeUtils.isLegalChar(code)) {
                if (code >= '\u007f') {
                    outResp.append("&#");
                    outResp.append((int)code);
                    outResp.append(";");
                } else {
                    outResp.append(str.charAt(i));
                }
            }
            ++i;
        }
        return outResp.toString();
    }

    public static CharSequence encodeUTFDoubleByteCharsAndQuoutesAsEntities(CharSequence str) {
        if (str == null) {
            return null;
        }
        StringBuilder outResp = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char code = str.charAt(i);
            if (StringXMLEncodeUtils.isLegalChar(code)) {
                if (code > '\u007f' || code == '\"' || code == '\'') {
                    outResp.append("&#");
                    outResp.append((int)code);
                    outResp.append(";");
                } else {
                    outResp.append(str.charAt(i));
                }
            }
            ++i;
        }
        return outResp.toString();
    }

    public static CharSequence decodeUTFDoubleByteCharsFromEntities(CharSequence str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(str.length());
        String regExp = "&#(([0-9]{1,7})|(x[0-9a-f]{1,6}));?";
        Pattern p = Pattern.compile(regExp, 2);
        Matcher m = p.matcher(str);
        boolean found = m.find();
        if (found) {
            do {
                String numericValue = m.group(1);
                char c = '\u0000';
                c = numericValue.startsWith("x") || numericValue.startsWith("X") ? (char)Integer.parseInt(numericValue, 16) : (char)Integer.parseInt(numericValue);
                m.appendReplacement(result, Character.toString(c));
            } while (found = m.find());
            m.appendTail(result);
            return result.toString();
        }
        return str;
    }
}

