/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.commons.io.input.CharSequenceReader;
import r01f.resources.ResourcesLoader;

class StringPersistenceUtils {
    StringPersistenceUtils() {
    }

    public static String load(ResourcesLoader loader, String filePath) throws IOException {
        InputStream is = loader.getInputStream(filePath, true);
        try {
            String outStr;
            String string = outStr = StringPersistenceUtils.load(is);
            return string;
        }
        finally {
            if (Collections.singletonList(is).get(0) != null) {
                is.close();
            }
        }
    }

    public static String load(ResourcesLoader loader, String filePath, Charset encoding) throws IOException {
        InputStream is = loader.getInputStream(filePath, true);
        try {
            String outStr;
            String string = outStr = StringPersistenceUtils.load(is, encoding);
            return string;
        }
        finally {
            if (Collections.singletonList(is).get(0) != null) {
                is.close();
            }
        }
    }

    public static String load(File f) throws IOException {
        String outStr = StringPersistenceUtils.load(f, null);
        return outStr;
    }

    public static String load(File f, Charset encoding) throws IOException {
        Charset theEncoding = encoding != null ? encoding : Charset.defaultCharset();
        FileInputStream fis = new FileInputStream(f);
        try {
            String string;
            block8: {
                BufferedInputStream bis = new BufferedInputStream(fis);
                try {
                    String outStr;
                    string = outStr = StringPersistenceUtils.load(bis, theEncoding);
                    if (Collections.singletonList(bis).get(0) == null) break block8;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(bis).get(0) != null) {
                        bis.close();
                    }
                    throw throwable;
                }
                bis.close();
            }
            return string;
        }
        finally {
            if (Collections.singletonList(fis).get(0) != null) {
                fis.close();
            }
        }
    }

    public static String load(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        String outStr = StringPersistenceUtils.load(is, null);
        return outStr;
    }

    public static String load(InputStream is, Charset encoding) throws IOException {
        Charset theEncoding = encoding != null ? encoding : Charset.defaultCharset();
        InputStreamReader r = new InputStreamReader(is, theEncoding);
        try {
            String outStr;
            String string = outStr = StringPersistenceUtils.load(r);
            return string;
        }
        finally {
            if (Collections.singletonList(r).get(0) != null) {
                ((Reader)r).close();
            }
        }
    }

    public static String load(Reader r) throws IOException {
        StringBuilder outString = new StringBuilder();
        if (r != null) {
            char[] buf = new char[2048];
            int charsReaded = -1;
            do {
                if ((charsReaded = r.read(buf)) == -1) continue;
                outString.append(new String(buf, 0, charsReaded));
            } while (charsReaded != -1);
            return outString.toString();
        }
        return null;
    }

    public static String load(Reader r, Charset encoding) throws IOException {
        Charset theEncoding = encoding != null ? encoding : Charset.defaultCharset();
        String srcString = StringPersistenceUtils.load(r);
        ByteBuffer bb = theEncoding.encode(CharBuffer.wrap(srcString));
        return bb.toString();
    }

    public static void save(CharSequence theString, File f) throws IOException {
        BufferedReader reader = new BufferedReader((Reader)new CharSequenceReader(theString));
        BufferedWriter writer = new BufferedWriter(new FileWriter(f, false));
        String line = reader.readLine();
        while (line != null) {
            writer.write(String.valueOf(line) + "\r\n");
            line = reader.readLine();
        }
        reader.close();
        writer.flush();
        writer.close();
    }

    public static void save(CharSequence theString, String filePath) throws IOException {
        StringPersistenceUtils.save(theString, new File(filePath));
    }
}

