/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;

public class StringEncodeUtils {
    public static CharSequence encode(CharSequence str, Charset encoding) {
        if (str == null) {
            return null;
        }
        Charset theEncoding = encoding != null ? encoding : Charset.defaultCharset();
        CharBuffer cb = CharBuffer.wrap(str);
        ByteBuffer bb = theEncoding.encode(cb);
        CharBuffer outCb = theEncoding.decode(bb);
        return outCb;
    }

    public static CharSequence encodeUTF(CharSequence str) {
        return StringEncodeUtils.encode(str, Charset.forName("UTF-8"));
    }

    public static CharSequence encodeISO8859(CharSequence str) {
        return StringEncodeUtils.encode(str, Charset.forName("ISO-8859-1"));
    }

    public static CharSequence windows1252ToIso8859(CharSequence str) {
        if (str == null) {
            return null;
        }
        StringBuilder modif = new StringBuilder(str);
        int i = 0;
        while (i < str.length()) {
            char origCharAsInt = str.charAt(i);
            switch (origCharAsInt) {
                case '\u2018': {
                    modif.setCharAt(i, '\'');
                    break;
                }
                case '\u2019': {
                    modif.setCharAt(i, '\'');
                    break;
                }
                case '\u201a': {
                    modif.setCharAt(i, '\'');
                    break;
                }
                case '\u201c': {
                    modif.setCharAt(i, '\"');
                    break;
                }
                case '\u201d': {
                    modif.setCharAt(i, '\"');
                    break;
                }
                case '\u201e': {
                    modif.setCharAt(i, '\"');
                    break;
                }
                case '\u2039': {
                    modif.setCharAt(i, '\'');
                    break;
                }
                case '\u203a': {
                    modif.setCharAt(i, '\'');
                    break;
                }
                case '\u02dc': {
                    modif.setCharAt(i, '~');
                    break;
                }
                case '\u2013': {
                    modif.setCharAt(i, '-');
                    break;
                }
                case '\u2014': {
                    modif.setCharAt(i, '-');
                    break;
                }
                case '\u0178': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u017e': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u0153': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u0161': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u2122': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u2022': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u017d': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u0152': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u0160': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u2030': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u02c6': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u2021': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u2020': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u2026': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u0192': {
                    modif.deleteCharAt(i);
                    break;
                }
                case '\u20ac': {
                    modif.deleteCharAt(i);
                    break;
                }
                default: {
                    modif.setCharAt(i, str.charAt(i));
                }
            }
            ++i;
        }
        return modif;
    }

    public static CharSequence filterAndReplaceChars(CharSequence strToBeFiltered, char[] charsToFilter, String[] charsFiltered) {
        if (strToBeFiltered == null) {
            return null;
        }
        char[] content = new char[strToBeFiltered.length()];
        int i = 0;
        while (i < strToBeFiltered.length()) {
            content[i] = strToBeFiltered.charAt(i);
            ++i;
        }
        StringBuilder result = new StringBuilder(content.length + 50);
        int i2 = 0;
        while (i2 < content.length) {
            boolean replaced = false;
            int j = 0;
            while (j < charsToFilter.length) {
                if (content[i2] == charsToFilter[j]) {
                    result.append(charsFiltered[j]);
                    replaced = true;
                }
                ++j;
            }
            if (!replaced) {
                result.append(content[i2]);
            }
            ++i2;
        }
        return result.toString();
    }

    public static CharSequence urlEncode(CharSequence str) throws EncoderException {
        if (str == null) {
            return null;
        }
        URLCodec codec = new URLCodec();
        String encodedStr = codec.encode(str.toString());
        return encodedStr;
    }

    public static CharSequence urlDecode(CharSequence str) throws DecoderException {
        if (str == null) {
            return null;
        }
        URLCodec codec = new URLCodec();
        String encodedStr = codec.decode(str.toString());
        return encodedStr;
    }
}

