/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import java.util.Map;
import r01f.reflection.ReflectionException;
import r01f.reflection.ReflectionUtils;

class StringCustomizeUtils {
    StringCustomizeUtils() {
    }

    public static String replaceVariableValues(String inStr, String varDelim, Map<String, String> varValues) {
        return StringCustomizeUtils.replaceVariableValues(inStr, varDelim.charAt(0), varValues, false);
    }

    public static String replaceVariableValues(String inStr, char varDelim, Map<String, String> varValues) {
        return StringCustomizeUtils.replaceVariableValues(inStr, varDelim, varValues, false);
    }

    public static String replaceVariableValues(String inStr, String varDelim, Map<String, String> varValues, boolean deep) {
        return StringCustomizeUtils.replaceVariableValues(inStr, varDelim.charAt(0), varValues, deep);
    }

    public static String replaceVariableValues(String inStr, char varDelim, Map<String, String> varValues, boolean deep) {
        String delim = "" + varDelim;
        char[] charsToEscape = new char[]{'.', '?', '*', '+', '^', '$'};
        int i = 0;
        while (i < charsToEscape.length) {
            if (charsToEscape[i] == varDelim) {
                delim = "\\" + charsToEscape[i];
                break;
            }
            ++i;
        }
        String outString = inStr;
        if (varValues != null) {
            for (Map.Entry<String, String> me : varValues.entrySet()) {
                String currStrToReplace = String.valueOf(delim) + me.getKey() + delim;
                String currVarValue = me.getValue();
                if (currVarValue == null) continue;
                if (deep && currVarValue.indexOf(varDelim) >= 0) {
                    currVarValue = StringCustomizeUtils.replaceVariableValues(currVarValue, varDelim, varValues, false);
                }
                if (currVarValue.indexOf("$") >= 0) {
                    currVarValue = currVarValue.replaceAll("\\$", "\\\\\\$");
                }
                outString = outString.replaceAll(currStrToReplace, currVarValue);
            }
        }
        return outString;
    }

    public static String replaceVariableValuesUsingReflection(String inStr, String varDelim, Object obj, Map<String, String> varPaths) throws ReflectionException {
        StringBuilder outBuff = new StringBuilder(inStr.length());
        int p1 = 0;
        int v1 = -1;
        int v2 = -1;
        String varName = null;
        String varPath = null;
        String varValue = null;
        boolean substitution = false;
        do {
            substitution = false;
            v1 = inStr.indexOf(varDelim, p1);
            if (v1 >= 0) {
                v2 = inStr.indexOf(varDelim, v1 + 1);
            }
            if (v2 <= v1) continue;
            outBuff.append(inStr.substring(p1, v1));
            varName = inStr.substring(v1 + 1, v2);
            if (varName.length() > 0) {
                varPath = varPaths.get(varName);
                if (varPath == null) {
                    outBuff.append("null");
                } else {
                    varValue = (String)ReflectionUtils.getMemberValueUsingPath(obj, varPath, false);
                    outBuff.append(varValue);
                }
            } else if (varName.length() == 0) {
                outBuff.append(varDelim);
                outBuff.append(varDelim);
            }
            p1 = v2 + 1;
            v1 = -1;
            v2 = -1;
            substitution = true;
        } while (substitution);
        if (p1 < inStr.length()) {
            outBuff.append(inStr.substring(p1));
        }
        return outBuff.toString();
    }
}

