/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Numbers {
    public static final int INTEGER_WIDTH = 4;

    public static boolean isNumberType(Class<?> type) {
        return type.equals(Number.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(Short.class) || type.equals(Byte.class);
    }

    public static boolean isEven(int intNum) {
        return !Numbers.isOdd(intNum);
    }

    public static boolean isOdd(int intNum) {
        return (intNum & 1) != 0;
    }

    public static boolean isEven(long longNum) {
        return !Numbers.isOdd(longNum);
    }

    public static boolean isOdd(long longNum) {
        return (longNum & 1L) != 0L;
    }

    private static int getMask(int bitIndex) {
        return 1 << bitIndex;
    }

    public static int setBit(int originalInt, int bitIndex) {
        return originalInt | Numbers.getMask(bitIndex);
    }

    public static int clearBit(int originalInt, int bitIndex) {
        return originalInt & ~Numbers.getMask(bitIndex);
    }

    public static boolean getBit(int integer, int bitIndex) {
        return (integer & Numbers.getMask(bitIndex)) != 0;
    }

    public static byte[] intToBytes(int integer) {
        byte[] byteArray = new byte[4];
        int i = 0;
        while (i < 4) {
            byteArray[i] = (byte)(integer >> 8 * i & 0xFF);
            ++i;
        }
        return byteArray;
    }

    public static int bytesToInt(byte[] byteArray) {
        int integer = 0;
        int i = 0;
        while (i < byteArray.length) {
            integer |= byteArray[i] << 8 * i;
            ++i;
        }
        return integer;
    }

    public static byte toByte(double d) {
        if (d < -128.0 || d > 127.0) {
            throw new IllegalArgumentException("Number is too large. Range is -128 to 127");
        }
        return new Double(d).byteValue();
    }

    public static byte toByte(float f) {
        if (f < -128.0f || f > 127.0f) {
            throw new IllegalArgumentException("Number is too large. Range is -128 to 127");
        }
        return new Float(f).byteValue();
    }

    public static byte toByte(int i) {
        if (i < -128 || i > 127) {
            throw new IllegalArgumentException("Number is too large. Range is -128 to 127");
        }
        return new Integer(i).byteValue();
    }

    public static byte toByte(long l) {
        if (l < -128L || l > 127L) {
            throw new IllegalArgumentException("Number is too large. Range is -128 to 127");
        }
        return new Long(l).byteValue();
    }

    public static byte toByte(short sh) {
        if (sh < -128 || sh > 127) {
            throw new IllegalArgumentException("Number is too large. Range is -128 to 127");
        }
        return new Short(sh).byteValue();
    }

    public static byte toByte(String s) {
        long l = Numbers.toLong(s);
        if (l < -128L || l > 127L) {
            throw new IllegalArgumentException("Number is too large. Range is -128 to 127");
        }
        return new Long(l).byteValue();
    }

    public static double toDouble(byte b) {
        return new Byte(b).doubleValue();
    }

    public static double toDouble(float f) {
        return new Float(f).doubleValue();
    }

    public static double toDouble(int i) {
        return new Integer(i).doubleValue();
    }

    public static double toDouble(long l) {
        return new Long(l).doubleValue();
    }

    public static double toDouble(short s) {
        return new Short(s).doubleValue();
    }

    public static double toDouble(String s) {
        return new Double(s);
    }

    public static float toFloat(byte b) {
        return new Byte(b).floatValue();
    }

    public static float toFloat(double d) {
        if (d < 1.40239846 * Math.pow(10.0, -45.0) || d > 3.40282347 * Math.pow(10.0, 38.0)) {
            throw new IllegalArgumentException("Number is too large. Range is 1.40239846 x 10^-45 to 3.40282347 x 10^38 ");
        }
        return new Double(d).floatValue();
    }

    public static float toFloat(int i) {
        return new Integer(i).floatValue();
    }

    public static float toFloat(long l) {
        return new Long(l).floatValue();
    }

    public static float toFloat(short sh) {
        return new Short(sh).floatValue();
    }

    public static float toFloat(String s) {
        return new Float(s).floatValue();
    }

    public static int toInt(byte b) {
        return new Byte(b).intValue();
    }

    public static int toInt(double d) {
        if (d < -2.147483648E9 || d > 2.147483647E9) {
            throw new IllegalArgumentException("Number is too large. Range is -2,147,483,648 to 2,147,483,647");
        }
        return new Double(d).intValue();
    }

    public static int toInt(float f) {
        if (f < -2.1474836E9f || f > 2.1474836E9f) {
            throw new IllegalArgumentException("Number is too large. Range is -2,147,483,648 to 2,147,483,647");
        }
        return new Float(f).intValue();
    }

    public static int toInt(long l) {
        return new Long(l).intValue();
    }

    public static int toInt(short sh) {
        return new Short(sh).intValue();
    }

    public static int toInt(String s) {
        long l = Numbers.toLong(s);
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Number is too large. Range is -2,147,483,648 to 2,147,483,647");
        }
        return new Long(l).intValue();
    }

    public static long toLong(byte b) {
        return new Byte(b).longValue();
    }

    public static long toLong(double d) {
        return new Double(d).longValue();
    }

    public static long toLong(float f) {
        return new Float(f).longValue();
    }

    public static long toLong(int i) {
        return new Long(i);
    }

    public static long toLong(short sh) {
        return new Short(sh).longValue();
    }

    public static long toLong(String s) {
        double d;
        int index = s.indexOf(".");
        String newLong = s;
        if (index != -1) {
            newLong = newLong.substring(0, index);
        }
        if ((d = Numbers.toDouble(newLong)) < -9.223372036854776E18 || d > 9.223372036854776E18) {
            throw new IllegalArgumentException("Number is too large. Range is -9,223,372,036,854,775,808 to 9,223,372,036,854,775,807");
        }
        return new Double(d).longValue();
    }

    public static short toShort(byte b) {
        return new Byte(b).shortValue();
    }

    public static short toShort(double d) {
        if (d < -32768.0 || d > 32767.0) {
            throw new IllegalArgumentException("Number is too large.  Range is -32,768 to 32,767");
        }
        return new Double(d).shortValue();
    }

    public static short toShort(float f) {
        if (f < -32768.0f || f > 32767.0f) {
            throw new IllegalArgumentException("Number is too large.  Range is -32,768 to 32,767");
        }
        return new Float(f).shortValue();
    }

    public static short toShort(int i) {
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Number is too large.  Range is -32,768 to 32,767");
        }
        return new Integer(i).shortValue();
    }

    public static short toShort(long l) {
        if (l < -32768L || l > 32767L) {
            throw new IllegalArgumentException("Number is too large.  Range is -32,768 to 32,767");
        }
        return new Long(l).shortValue();
    }

    public static short toShort(String s) {
        long l = Numbers.toLong(s);
        if (l < -32768L || l > 32767L) {
            throw new IllegalArgumentException("Number is too large. Range is -32,768 to 32,767");
        }
        return new Long(l).shortValue();
    }

    public static String toString(byte d) {
        return Byte.toString(d);
    }

    public static String toString(double d) {
        return Double.toString(d);
    }

    public static String toString(float f) {
        return Float.toString(f);
    }

    public static String toString(int i) {
        return Integer.toString(i);
    }

    public static String toString(long l) {
        return Long.toString(l);
    }

    public static String toString(short sh) {
        return Short.toString(sh);
    }

    public static boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        Pattern p = Pattern.compile("^[0-9]+$");
        Matcher m = p.matcher(s);
        return m.find();
    }

    public static boolean isInteger(String strInt, int radix) {
        boolean isInteger = false;
        if (strInt != null) {
            try {
                Integer.parseInt(strInt, radix);
                isInteger = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isInteger;
    }

    public static boolean isInteger(String strInt) {
        return Numbers.isInteger(strInt, 10);
    }

    public static boolean isByte(String strByte, int radix) {
        boolean isByte = false;
        if (strByte != null) {
            try {
                Byte.parseByte(strByte, radix);
                isByte = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isByte;
    }

    public static boolean isByte(String strByte) {
        return Numbers.isByte(strByte, 10);
    }

    public static boolean isLong(String strLong, int radix) {
        boolean isLong = false;
        if (strLong != null) {
            try {
                Long.parseLong(strLong, radix);
                isLong = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isLong;
    }

    public static boolean isLong(String strLong) {
        return Numbers.isLong(strLong, 10);
    }

    public static boolean isFloat(String strFloat) {
        boolean isFloat = false;
        if (strFloat != null) {
            try {
                Float.parseFloat(strFloat);
                isFloat = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isFloat;
    }

    public static boolean isShort(String strShort) {
        boolean isShort = false;
        if (strShort != null) {
            try {
                Float.parseFloat(strShort);
                isShort = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isShort;
    }

    public static boolean isDouble(String strDouble) {
        boolean isDouble = false;
        if (strDouble != null) {
            try {
                Double.parseDouble(strDouble);
                isDouble = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isDouble;
    }
}

