/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Lists {
    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    @GwtCompatible(serializable=true)
    public static <E> List<E> newArrayList(E ... elements) {
        return com.google.common.collect.Lists.newArrayList((Object[])elements);
    }

    @GwtCompatible(serializable=true)
    public static <E> List<E> newArrayList(Iterable<? extends E> elements) {
        return com.google.common.collect.Lists.newArrayList(elements);
    }

    @GwtCompatible(serializable=true)
    public static <E> List<E> newArrayList(Iterator<? extends E> elements) {
        return com.google.common.collect.Lists.newArrayList(elements);
    }

    @GwtCompatible(serializable=true)
    public static <E> List<E> newArrayList() {
        return com.google.common.collect.Lists.newArrayList();
    }

    @GwtCompatible(serializable=true)
    public static <E> List<E> newArrayListWithCapacity(int size) {
        return com.google.common.collect.Lists.newArrayListWithCapacity((int)size);
    }

    @GwtCompatible(serializable=true)
    public static <E> List<E> newLinkedList() {
        return com.google.common.collect.Lists.newLinkedList();
    }

    @GwtCompatible(serializable=true)
    public static <E> List<E> newLinkedList(Iterable<? extends E> elements) {
        return com.google.common.collect.Lists.newLinkedList(elements);
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList(Iterator<? extends E> elements) {
        if (elements == null || !elements.hasNext()) {
            return null;
        }
        LinkedList list = (LinkedList)Lists.newLinkedList();
        do {
            list.add(elements.next());
        } while (elements.hasNext());
        return list;
    }

    public static <E> List<List<E>> partition(List<E> list, int size) {
        return com.google.common.collect.Lists.partition(list, (int)size);
    }

    public static <E> List<E> reverse(List<E> list) {
        return com.google.common.collect.Lists.reverse(list);
    }

    public static <E, T> List<T> transform(List<E> fromList, Function<? super E, ? extends T> function) {
        return com.google.common.collect.Lists.transform(fromList, function);
    }
}

