/*
 * Decompiled with CFR 0.152.
 */
package r01f.util.types;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import r01f.util.types.Numbers;
import r01f.util.types.Strings;

public abstract class Dates {
    public static final int LANG_ES = 0;
    public static final int LANG_EU = 1;
    public static final String ES_DEFAULT_FORMAT = "dd/MM/yyyy";
    public static final String EU_DEFAULT_FORMAT = "yyyy/MM/dd";
    public static final String DEFAULT_FORMAT = "dd/MM/yyyy";

    public static String langFormat(String lang, Properties langFormats) {
        String fmt = null;
        if (langFormats != null) {
            if (lang != null) {
                fmt = langFormats.getProperty(lang);
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("default");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("def");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("other");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("all");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("es");
            }
        }
        if (fmt == null) {
            fmt = "dd/MM/yyyy";
        }
        return fmt;
    }

    public static long asMillis(Date date) {
        if (date == null) {
            return Long.MIN_VALUE;
        }
        return date.getTime();
    }

    public static Date fromMillis(long milis) {
        return new Date(milis);
    }

    public static String format(Date date, String fmt) {
        return Dates.format(date, fmt, Locale.getDefault());
    }

    public static String format(Date date, String fmt, Locale locale) {
        Date theDate = date != null ? date : new Date();
        String theFmt = fmt;
        if (theFmt != null) {
            if (theFmt.equalsIgnoreCase("millis")) {
                return Long.toString(theDate.getTime());
            }
            if (theFmt.equalsIgnoreCase("seconds")) {
                return Long.toString(theDate.getTime() / 1000L);
            }
        }
        SimpleDateFormat formatter = null;
        if (Strings.isNullOrEmpty(theFmt)) {
            theFmt = "dd/MM/yyyy";
        }
        formatter = new SimpleDateFormat(theFmt, locale);
        if (locale.equals(Locale.ENGLISH)) {
            TimeZone zone = formatter.getTimeZone();
            int msInMin = 60000;
            int minInHr = 60;
            int minutes = zone.getOffset(theDate.getTime()) / 60000;
            int hours = minutes / 60;
            zone = TimeZone.getTimeZone("GMT Time" + (hours >= 0 ? "+" : "") + hours + ":" + minutes);
            formatter.setTimeZone(zone);
        }
        return formatter.format(theDate);
    }

    public static String format(Date date, String lang, Properties langFormats) {
        String fmt = Dates.langFormat(lang, langFormats);
        return Dates.format(date, fmt);
    }

    public static Date fromFormatedString(String dateStr, String format) {
        if (dateStr == null) {
            return null;
        }
        String theDateStr = new String(dateStr);
        String fmt = new String(format);
        if (Strings.isNullOrEmpty(fmt)) {
            fmt = "dd/MM/yyyy";
        }
        if (Strings.isNullOrEmpty(theDateStr)) {
            return new Date();
        }
        if (format.equalsIgnoreCase("millis") && Numbers.isLong(dateStr)) {
            return new Date(Long.parseLong(dateStr));
        }
        if (format.equalsIgnoreCase("seconds") && Numbers.isLong(dateStr)) {
            return new Date(Long.parseLong(dateStr) * 1000L);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(fmt);
        formatter.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        Date outDate = formatter.parse(theDateStr, pos);
        return outDate;
    }

    public static Date fromLanguageFormatedString(String dateStr, String lang, Properties langFormats) {
        if (dateStr == null) {
            return null;
        }
        String fmt = Dates.langFormat(lang, langFormats);
        return Dates.fromFormatedString(dateStr, fmt);
    }

    public static String reformat(String dateStr, String oldFormat, String newFormat) {
        String theOldFmt = Strings.isNullOrEmpty(oldFormat) ? "dd/MM/yyyy" : oldFormat;
        String theNewFmt = StringUtils.isEmpty((String)newFormat) ? "dd/MM/yyyy" : newFormat;
        String theDateStr = Strings.isNullOrEmpty(dateStr) ? Dates.format(new Date(), theOldFmt) : dateStr;
        Date newDate = Dates.fromFormatedString(theDateStr, theOldFmt);
        return Dates.format(newDate, theNewFmt);
    }

    public static String timeStampFormatted() {
        String format = "dd/MM/yyyy [HH:mm:ss:SSS]";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static String currentDate(String lang) {
        if (lang != null) {
            if (lang.equals("es")) {
                return Dates.currentDate(0);
            }
            if (lang.equals("eu")) {
                return Dates.currentDate(1);
            }
        }
        return null;
    }

    public static String currentDate(int language) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+1:00"), new Locale("es", "ES"));
        int day = calendar.get(5);
        int dayOfWeek = calendar.get(7);
        int monthOfYear = calendar.get(2);
        int year = calendar.get(1);
        String outDate = null;
        switch (language) {
            case 0: {
                outDate = Strings.create().add((CharSequence)Dates._getDayOfWeekName(dayOfWeek, 0)).add((CharSequence)", ").add((CharSequence)Integer.toString(calendar.get(5))).add((CharSequence)" de ").add((CharSequence)Dates._getMonthName(monthOfYear, 0)).add((CharSequence)" de ").add((CharSequence)Integer.toString(year)).asString();
                break;
            }
            case 1: {
                outDate = Strings.create().add((CharSequence)Dates._getDayOfWeekName(dayOfWeek, 1)).add((CharSequence)", ").add((CharSequence)Integer.toString(year)).add((CharSequence)"-ko ").add((CharSequence)Dates._getMonthName(monthOfYear, 1)).add((CharSequence)"ren ").add((CharSequence)Integer.toString(calendar.get(5))).asString();
                break;
            }
            default: {
                outDate = String.valueOf(day) + "/" + monthOfYear + "/" + year;
            }
        }
        return outDate;
    }

    private static String _getDayOfWeekName(int dayOfWeek, int language) {
        String outDayName = null;
        switch (language) {
            case 0: {
                outDayName = Dates._getDayOfWeekInCastellano(dayOfWeek);
                break;
            }
            case 1: {
                outDayName = Dates._getDayOfWeekInEuskera(dayOfWeek);
                break;
            }
            default: {
                outDayName = "";
            }
        }
        return outDayName;
    }

    private static String _getMonthName(int month, int language) {
        String outMonthName = null;
        switch (language) {
            case 0: {
                outMonthName = Dates._getMonthNameInCastellano(month);
                break;
            }
            case 1: {
                outMonthName = Dates._getMonthNameInEuskera(month);
                break;
            }
            default: {
                outMonthName = "";
            }
        }
        return outMonthName;
    }

    private static String _getDayOfWeekInEuskera(int dayOfWeek) {
        String outDayOfWeek = null;
        switch (dayOfWeek) {
            case 1: {
                outDayOfWeek = "Igandea";
                break;
            }
            case 2: {
                outDayOfWeek = "Astelehena";
                break;
            }
            case 3: {
                outDayOfWeek = "Asteartea";
                break;
            }
            case 4: {
                outDayOfWeek = "Asteazkena";
                break;
            }
            case 5: {
                outDayOfWeek = "Osteguna";
                break;
            }
            case 6: {
                outDayOfWeek = "Ostirala";
                break;
            }
            case 7: {
                outDayOfWeek = "Larunbata";
                break;
            }
            default: {
                outDayOfWeek = "";
            }
        }
        return outDayOfWeek;
    }

    private static String _getDayOfWeekInCastellano(int dayOfWeek) {
        String outDayOfWeek = null;
        switch (dayOfWeek) {
            case 1: {
                outDayOfWeek = "Domingo";
                break;
            }
            case 2: {
                outDayOfWeek = "Lunes";
                break;
            }
            case 3: {
                outDayOfWeek = "Martes";
                break;
            }
            case 4: {
                outDayOfWeek = "Mi\u00e9rcoles";
                break;
            }
            case 5: {
                outDayOfWeek = "Jueves";
                break;
            }
            case 6: {
                outDayOfWeek = "Viernes";
                break;
            }
            case 7: {
                outDayOfWeek = "S\u00e1bado";
                break;
            }
            default: {
                outDayOfWeek = "";
            }
        }
        return outDayOfWeek;
    }

    private static String _getMonthNameInEuskera(int month) {
        String outMonthName = null;
        switch (month) {
            case 0: {
                outMonthName = "Urtarila";
                break;
            }
            case 1: {
                outMonthName = "Otsaila";
                break;
            }
            case 2: {
                outMonthName = "Martxoa";
                break;
            }
            case 3: {
                outMonthName = "Aprila";
                break;
            }
            case 4: {
                outMonthName = "Maiatza";
                break;
            }
            case 5: {
                outMonthName = "Ekaina";
                break;
            }
            case 6: {
                outMonthName = "Uztaila";
                break;
            }
            case 7: {
                outMonthName = "Abuztua";
                break;
            }
            case 8: {
                outMonthName = "Iraila";
                break;
            }
            case 9: {
                outMonthName = "Urria";
                break;
            }
            case 10: {
                outMonthName = "Azaroa";
                break;
            }
            case 11: {
                outMonthName = "Abendua";
                break;
            }
            default: {
                outMonthName = "";
            }
        }
        return outMonthName;
    }

    private static String _getMonthNameInCastellano(int month) {
        String outMonthName = null;
        switch (month) {
            case 0: {
                outMonthName = "Enero";
                break;
            }
            case 1: {
                outMonthName = "Febrero";
                break;
            }
            case 2: {
                outMonthName = "Marzo";
                break;
            }
            case 3: {
                outMonthName = "Abril";
                break;
            }
            case 4: {
                outMonthName = "Mayo";
                break;
            }
            case 5: {
                outMonthName = "Junio";
                break;
            }
            case 6: {
                outMonthName = "Julio";
                break;
            }
            case 7: {
                outMonthName = "Agosto";
                break;
            }
            case 8: {
                outMonthName = "Septiembre";
                break;
            }
            case 9: {
                outMonthName = "Octubre";
                break;
            }
            case 10: {
                outMonthName = "Noviembre";
                break;
            }
            case 11: {
                outMonthName = "Diciembre";
                break;
            }
            default: {
                outMonthName = "";
            }
        }
        return outMonthName;
    }

    public static Date rollDateToMaximum(Date date) {
        Calendar theCal = Calendar.getInstance(TimeZone.getTimeZone("GMT+1:00"), new Locale("es", "ES"));
        theCal.setTime(date);
        return Dates.rollCalendarToMaximum(theCal).getTime();
    }

    public static Date rollDateToMinimum(Date date) {
        Calendar theCal = Calendar.getInstance();
        theCal.setTime(date);
        return Dates.rollCalendarToMinimum(theCal).getTime();
    }

    public static Calendar rollCalendarToMaximum(Calendar theCal) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+1:00"), new Locale("es", "ES"));
        cal.setTime(theCal.getTime());
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(14, cal.getActualMaximum(14));
        return cal;
    }

    public static Calendar rollCalendarToMinimum(Calendar theCal) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(theCal.getTime());
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(14, cal.getActualMinimum(14));
        return cal;
    }
}

