/*
 * Decompiled with CFR 0.152.
 */
package r01f.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Pager<T>
implements Serializable {
    private static final long serialVersionUID = -4966151337012633456L;
    private List<PageFirstAndLastItemsOids<T>> _pages = new ArrayList<PageFirstAndLastItemsOids<T>>();
    private int _pageSize = 10;
    private int _blockSize = 5;
    private int _totalNumberOfItems;
    private int _currentPageOrderNumber = 1;

    public Pager() throws IllegalArgumentException {
    }

    public Pager(int newPageSize) throws IllegalArgumentException {
        this();
        if (newPageSize <= 0) {
            throw new IllegalArgumentException("El numero de elementos en la pagina no puede ser menor que cero");
        }
        this._pageSize = newPageSize;
    }

    public Pager(int newPageSize, int newBlockSize) throws IllegalArgumentException {
        this();
        if (newPageSize <= 0 || newBlockSize <= 0) {
            throw new IllegalArgumentException("El numero de elementos en la pagina o el tama\u00f1o del bloque de p\u00e1ginas de la barra de navegaci\u00f3n, no puede ser menor que cero");
        }
        this._pageSize = newPageSize;
        this._blockSize = newBlockSize;
    }

    public void addItem(T itemOid) throws IllegalArgumentException {
        if (itemOid == null) {
            throw new IllegalArgumentException("NO se puede insertar un itemOid=null en el pager!");
        }
        if (this._pages == null) {
            this._pages = new ArrayList<PageFirstAndLastItemsOids<T>>();
        }
        PageFirstAndLastItemsOids<Object> currPageItem = null;
        if (this._totalNumberOfItems % this._pageSize == 0) {
            currPageItem = new PageFirstAndLastItemsOids();
            currPageItem._firstItemOid = itemOid;
            currPageItem._lastItemOid = itemOid;
            this._pages.add(currPageItem);
        } else {
            currPageItem = this._pages.get(this._pages.size() - 1);
            currPageItem._lastItemOid = itemOid;
        }
        ++this._totalNumberOfItems;
    }

    public int[] getCurrentBlockPageNumbers() {
        int numeroBloques = this.getBlockCount();
        int bloqueActual = this.getCurrentBlockNumber();
        int currentBlockSize = this._blockSize;
        if (bloqueActual == numeroBloques) {
            currentBlockSize = this._pages.size() - (numeroBloques - 1) * this._blockSize;
        }
        int[] blockPages = new int[currentBlockSize];
        int j = 0;
        int i = 1;
        while (i <= blockPages.length) {
            blockPages[i - 1] = i;
            ++i;
        }
        i = (bloqueActual - 1) * this._blockSize + 1;
        while (i <= bloqueActual * this._blockSize && i <= this._pages.size()) {
            blockPages[j++] = i++;
        }
        return blockPages;
    }

    public int getCurrentBlockNumber() {
        int bloqueActual = new Double((this._currentPageOrderNumber - 1) / this._blockSize + 1).intValue();
        return bloqueActual;
    }

    public int getBlockCount() {
        double dblPaginas = this._pages.size();
        int numeroBloques = new Double(Math.ceil(dblPaginas / (double)this._blockSize)).intValue();
        return numeroBloques;
    }

    public T getCurrentPageFirstItemOid() {
        return this.getPageFirstItemOid(this._currentPageOrderNumber);
    }

    public T getCurrentPageLastItemOid() {
        return this.getPageLastItemOid(this._currentPageOrderNumber);
    }

    public T getPrevPageLastItemOid() {
        return this._currentPageOrderNumber > 1 ? (T)this.getPageLastItemOid(this._currentPageOrderNumber - 1) : null;
    }

    public T getNextPageFirstItemOid() {
        return this._currentPageOrderNumber < this._pages.size() ? (T)this.getPageFirstItemOid(this._currentPageOrderNumber + 1) : null;
    }

    public T getPageFirstItemOid(int inPage) throws IllegalArgumentException {
        if (inPage < 1 || inPage > this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        PageFirstAndLastItemsOids<T> pageFirstAndLastItems = this._pages.get(inPage - 1);
        return (T)pageFirstAndLastItems._firstItemOid;
    }

    public T getPageLastItemOid(int inPage) throws IllegalArgumentException {
        if (inPage < 1 || inPage > this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        PageFirstAndLastItemsOids<T> pageFirstAndLastItems = this._pages.get(inPage - 1);
        return (T)pageFirstAndLastItems._lastItemOid;
    }

    public int getFirstPageOrderNumber() {
        return 1;
    }

    public int getLastPageOrderNumber() {
        return this._pages.size();
    }

    public int getPrevPageOrderNumber() {
        if (this._currentPageOrderNumber == 1) {
            return -1;
        }
        return this._currentPageOrderNumber - 1;
    }

    public int getNextPageOrderNumber() {
        if (this._currentPageOrderNumber == this._pages.size()) {
            return -1;
        }
        return this._currentPageOrderNumber + 1;
    }

    public int getCurrentPageFirstItemOrderNumber() {
        return this.getPageFirstItemOrderNumber(this._currentPageOrderNumber);
    }

    public int getCurrentPageLastItemOrderNumber() {
        return this.getPageLastItemOrderNumber(this._currentPageOrderNumber);
    }

    public int getPreviousPageLastItemOrderNumber() {
        if (this._currentPageOrderNumber == 1) {
            throw new IllegalArgumentException("P\u00e1gina Ilegal");
        }
        return this.getPageLastItemOrderNumber(this._currentPageOrderNumber - 1);
    }

    public int getNextPageFirstItemOrderNumber() {
        if (this._currentPageOrderNumber == this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina Ilegal");
        }
        return this.getPageFirstItemOrderNumber(this._currentPageOrderNumber + 1);
    }

    public int getPageFirstItemOrderNumber(int pageOrderNum) throws IllegalArgumentException {
        if (pageOrderNum < 1 || pageOrderNum > this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        if (pageOrderNum == this.getFirstPageOrderNumber()) {
            return 1;
        }
        return pageOrderNum * this._pageSize - this._pageSize + 1;
    }

    public int getPageLastItemOrderNumber(int pageOrderNum) throws IllegalArgumentException {
        if (pageOrderNum < 1 || pageOrderNum > this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        if (pageOrderNum == this.getLastPageOrderNumber()) {
            return this.getLastPageOrderNumber();
        }
        return pageOrderNum * this._pageSize;
    }

    public int getPrevBlockLastPageOrderNumber() {
        int[] currentBlockPageNums = this.getCurrentBlockPageNumbers();
        int prevBlockLastPage = currentBlockPageNums[0] == 1 ? 1 : currentBlockPageNums[0] - 1;
        return prevBlockLastPage;
    }

    public int getNextBlockFirstPageOrderNumber() {
        int[] currentBlockPageNums = this.getCurrentBlockPageNumbers();
        int nextBlockFirstPage = currentBlockPageNums[currentBlockPageNums.length - 1] == this._pages.size() ? currentBlockPageNums[currentBlockPageNums.length - 1] : currentBlockPageNums[currentBlockPageNums.length - 1] + 1;
        return nextBlockFirstPage;
    }

    public int getPrevBlockLastItemOrderNumber() {
        int prevBlockLastPageOrderNumber = this.getPrevBlockLastPageOrderNumber();
        return this.getPageLastItemOrderNumber(prevBlockLastPageOrderNumber);
    }

    public int getNextBlockFirstItemOrderNumber() {
        int nextBlockFirstPageOrderNumber = this.getNextBlockFirstPageOrderNumber();
        return this.getPageFirstItemOrderNumber(nextBlockFirstPageOrderNumber);
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public void goToFirstPage() {
        this._currentPageOrderNumber = 1;
    }

    public void goToLastPage() {
        this._currentPageOrderNumber = this._pages.size();
    }

    public void goToPrevPage() {
        if (this._currentPageOrderNumber == 1) {
            return;
        }
        --this._currentPageOrderNumber;
    }

    public void goToNextPage() {
        if (this._currentPageOrderNumber == this._pages.size()) {
            return;
        }
        ++this._currentPageOrderNumber;
    }

    public void goToPage(int newPage) throws IllegalArgumentException {
        if (newPage < 0 || newPage > this._pages.size()) {
            throw new IllegalArgumentException("P\u00e1gina ilegal");
        }
        this._currentPageOrderNumber = newPage;
    }

    public void goToPrevBlockLastPage() {
        this._currentPageOrderNumber = this.getPrevBlockLastPageOrderNumber();
    }

    public void goToNextBlockFirstPage() {
        this._currentPageOrderNumber = this.getNextBlockFirstPageOrderNumber();
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public void setPageSize(int _pageSize) {
        this._pageSize = _pageSize;
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    public void setBlockSize(int _blockSize) {
        this._blockSize = _blockSize;
    }

    public int getTotalNumberOfItems() {
        return this._totalNumberOfItems;
    }

    public int getCurrentPageOrderNumber() {
        return this._currentPageOrderNumber;
    }

    private class PageFirstAndLastItemsOids<U> {
        U _firstItemOid;
        U _lastItemOid;
    }
}

