/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.lazy;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import r01f.reflection.ReflectionUtils;
import r01f.types.lazy.BaseLazyMap;
import r01f.types.lazy.LazyCollectionsInterfaces;
import r01f.types.lazy.LazyMapFluentBuilder;

public class LazyNotCachedMap<K, V>
extends BaseLazyMap<K, V> {
    protected final Map<K, V> _currentEntries;
    protected final LazyCollectionsInterfaces.MapValuesSupplier<K, V> _valuesSupplier;

    LazyNotCachedMap(LazyCollectionsInterfaces.KeyIntrospector<K, V> keyIntrospector, Supplier<Set<K>> keySetSupplier, LazyCollectionsInterfaces.MapValuesSupplier<K, V> valuesSupplier, Map<K, V> currentEntriesMapInstance) {
        super(keyIntrospector, keySetSupplier);
        this._valuesSupplier = valuesSupplier;
        this._currentEntries = currentEntriesMapInstance;
    }

    public static <K1, V1, C1> LazyMapFluentBuilder<K1, V1, C1> builder() {
        return new LazyHashMapFluentBuilder<K1, V1, C1>(){

            @Override
            public Map<K1, V1> build() {
                super.checkBuilderParams();
                Supplier theKeySetSupplier = Suppliers.memoize(new LazyCollectionsInterfaces.MapKeysSupplier(this._keySetSupplier, this._keySetLoadCriteria));
                Map mapInstance = null;
                mapInstance = this._underlyingMapType == null || this._underlyingMapType == HashMap.class ? (this._initialCapacity > 0 ? new HashMap(this._initialCapacity) : new HashMap()) : (this._initialCapacity > 0 ? (Map)ReflectionUtils.createInstanceOf(this._underlyingMapType, new Class[]{Integer.class}, (Object[])new Integer[]{this._initialCapacity}) : (Map)ReflectionUtils.createInstanceOf(this._underlyingMapType));
                LazyNotCachedMap outMap = new LazyNotCachedMap(this._keyIntrospector, theKeySetSupplier, this._valuesSupplier, mapInstance);
                return outMap;
            }
        };
    }

    @Override
    public boolean isLoaded(K key) {
        return this._currentEntries.containsKey(key);
    }

    @Override
    protected V supplyValue(K key) {
        Object outVal = null;
        try {
            outVal = this._valuesSupplier.loadValue(key);
            if (outVal != null) {
                this._currentEntries.put(key, outVal);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return outVal;
    }

    @Override
    protected V putInCurrentEntries(K key, V value) {
        V outVal = this._currentEntries.put(key, value);
        return outVal;
    }

    @Override
    protected V removeFromCurrentEntries(K key) {
        V outVal = this._currentEntries.remove(key);
        return outVal;
    }

    @Override
    protected void clearCurrentEntries() {
        this._currentEntries.clear();
    }

    @Override
    protected Map<K, V> currentEntries() {
        return this._currentEntries;
    }

    static abstract class LazyHashMapFluentBuilder<K1, V1, C1>
    extends LazyMapFluentBuilder<K1, V1, C1> {
        LazyHashMapFluentBuilder() {
        }

        @Override
        public LazyMapFluentBuilder<K1, V1, C1> expiringEntriesEvery(long period, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("Entries expiration is NOT supported in a LazyMap; only in a CachedLazyMap");
        }

        @Override
        public void checkBuilderParams() {
            if (this._keyIntrospector == null) {
                throw new IllegalStateException("The KeyIntrospector is needed in order to introspect the key for a given value. The lazyLoadedMap cannot be built");
            }
            if (this._keySetSupplier == null) {
                throw new IllegalStateException("The keySetSupplier is needed in order to know ALL the keys for the map. The lazyLoadedMap cannot be built");
            }
            if (this._valuesSupplier == null) {
                throw new IllegalStateException("The valuesSupplier is needed in order to load lazily the value for a given key. The LazyLoadedMap cannot be built");
            }
        }
    }
}

