/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.lazy;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import java.util.Collection;
import java.util.Set;

public class LazyCollectionsInterfaces {

    public static interface CollectionValuesSupplier<V> {
        public Collection<V> loadValues();
    }

    public static interface KeyIntrospector<K, V> {
        public K of(V var1);
    }

    public static interface MapKeySetSupplier<K, C> {
        public Set<K> keysFor(C var1);
    }

    public static class MapKeysSupplier<K, C>
    implements Supplier<Set<K>> {
        private final MapKeySetSupplier<K, C> _keySetSupplier;
        private final C _criteria;

        public MapKeysSupplier(Object keySetSupplier, Object criteria) {
            this._keySetSupplier = (MapKeySetSupplier)keySetSupplier;
            this._criteria = criteria;
        }

        public Set<K> get() {
            return this._keySetSupplier.keysFor(this._criteria);
        }
    }

    public static abstract class MapValuesSupplier<K, V> {
        public abstract V loadValue(K var1);

        public CacheLoader<K, V> asCacheLoader() {
            return new CacheLoader<K, V>(){

                public V load(K key) throws Exception {
                    return MapValuesSupplier.this.loadValue(key);
                }
            };
        }
    }
}

