/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.lazy;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Set;
import r01f.types.lazy.BaseLazyMap;
import r01f.types.lazy.LazyCollectionsInterfaces;
import r01f.types.lazy.LazyMapFluentBuilder;

public class LazyCachedMap<K, V>
extends BaseLazyMap<K, V> {
    protected final LoadingCache<K, V> _currentEntries;

    LazyCachedMap(LazyCollectionsInterfaces.KeyIntrospector<K, V> keyIntrospector, Supplier<Set<K>> keySetSupplier, LoadingCache<K, V> currentEntriesMapInstance) {
        super(keyIntrospector, keySetSupplier);
        this._currentEntries = currentEntriesMapInstance;
    }

    public static <K1, V1, C1> LazyMapFluentBuilder<K1, V1, C1> builder() {
        return new LazyCachedMapFluentBuilder<K1, V1, C1>(){

            @Override
            public Map<K1, V1> build() {
                super.checkBuilderParams();
                Supplier theKeySetSupplier = Suppliers.memoize(new LazyCollectionsInterfaces.MapKeysSupplier(this._keySetSupplier, this._keySetLoadCriteria));
                LoadingCache mapInstance = CacheBuilder.newBuilder().initialCapacity(this._initialCapacity).expireAfterWrite(this._expirationPeriod, this._expirationPeriodTimeUnit).build(this._valuesSupplier.asCacheLoader());
                LazyCachedMap outMap = new LazyCachedMap(this._keyIntrospector, theKeySetSupplier, mapInstance);
                return outMap;
            }
        };
    }

    @Override
    public boolean isLoaded(K key) {
        return this._currentEntries.getIfPresent(key) != null;
    }

    @Override
    protected V supplyValue(K key) {
        try {
            return (V)this._currentEntries.get(key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected V putInCurrentEntries(K key, V value) {
        Object outVal = this._currentEntries.getIfPresent(key);
        this._currentEntries.put(key, value);
        return (V)outVal;
    }

    @Override
    protected V removeFromCurrentEntries(K key) {
        Object outVal = this._currentEntries.getIfPresent(key);
        if (outVal != null) {
            this._currentEntries.invalidate(key);
        }
        return (V)outVal;
    }

    @Override
    protected void clearCurrentEntries() {
        this._currentEntries.invalidateAll();
    }

    @Override
    protected Map<K, V> currentEntries() {
        return this._currentEntries.asMap();
    }

    static abstract class LazyCachedMapFluentBuilder<K1, V1, C1>
    extends LazyMapFluentBuilder<K1, V1, C1> {
        LazyCachedMapFluentBuilder() {
        }

        @Override
        public LazyMapFluentBuilder<K1, V1, C1> backedBy(Class<?> type) {
            throw new IllegalArgumentException("A LazyCachedMap is allways backed by a GUAVA's LoadingCache, so there is no need to specify the underlying Map type");
        }

        @Override
        public void checkBuilderParams() {
            if (this._keyIntrospector == null) {
                throw new IllegalStateException("The KeyIntrospector is needed in order to introspect the key for a given value. The lazyLoadedMap cannot be built");
            }
            if (this._keySetSupplier == null) {
                throw new IllegalStateException("The keySetSupplier is needed in order to know ALL the keys for the map. The lazyLoadedMap cannot be built");
            }
            if (this._valuesSupplier == null) {
                throw new IllegalStateException("The valuesSupplier is needed in order to load lazily the value for a given key. The LazyLoadedMap cannot be built");
            }
            if (this._expirationPeriod <= 0L) {
                throw new IllegalStateException("The expirationPeriod is needed in order to know how ofter clear the cached value for a given key. The LazyLoadedMap cannot be built");
            }
        }
    }
}

