/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.lazy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import r01f.types.dirtytrack.CollectionChangesTracker;
import r01f.types.lazy.LazyCollectionsInterfaces;
import r01f.types.lazy.LazyMap;
import r01f.util.types.collections.CollectionUtils;

abstract class BaseLazyMap<K, V>
implements LazyMap<K, V> {
    protected final LazyCollectionsInterfaces.KeyIntrospector<K, V> _keyIntrospector;
    protected final Supplier<Set<K>> _keySetSupplier;
    CollectionChangesTracker<K> _changesTracker = new CollectionChangesTracker();

    BaseLazyMap(LazyCollectionsInterfaces.KeyIntrospector<K, V> keyIntrospector, Supplier<Set<K>> keySetSupplier) {
        this._keyIntrospector = keyIntrospector;
        this._keySetSupplier = keySetSupplier;
    }

    protected abstract V supplyValue(K var1);

    protected abstract V putInCurrentEntries(K var1, V var2);

    protected abstract V removeFromCurrentEntries(K var1);

    protected abstract void clearCurrentEntries();

    protected abstract Map<K, V> currentEntries();

    @Override
    public int size() {
        return this._actualKeys().size();
    }

    @Override
    public boolean isEmpty() {
        return this._actualKeys().size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._actualKeys().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        boolean outContains = false;
        K key = this._keyIntrospector.of(value);
        if (key != null) {
            outContains = this.get(key) != null;
        }
        return outContains;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        V outVal = null;
        boolean isSuppliedKey = ((Set)this._keySetSupplier.get()).contains(key);
        boolean isNewOrUpdatedKey = this.isLoaded(key);
        boolean isValidKey = isSuppliedKey || isNewOrUpdatedKey;
        outVal = isValidKey && !this.isLoaded(key) ? (V)this.supplyValue(key) : (V)this.currentEntries().get(key);
        return outVal;
    }

    @Override
    public V put(K key, V value) {
        V outVal = null;
        if (key != null) {
            outVal = this.putInCurrentEntries(key, value);
            this._changesTracker.trackEntryInsertion(key);
        }
        return outVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (!CollectionUtils.isNullOrEmpty(m)) {
            for (Map.Entry<K, V> me : m.entrySet()) {
                this.put(me.getKey(), me.getValue());
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return (Set)this._keySetSupplier.get();
    }

    @Override
    public Collection<V> values() {
        AbstractUnmodifiableEntriesSet outCol = new AbstractUnmodifiableEntriesSet<V>(this._actualKeys()){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private Iterator<K> _keySetIterator;
                    {
                        this._keySetIterator = _keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._keySetIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        Object nextKey = this._keySetIterator.next();
                        return BaseLazyMap.this.get(nextKey);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("The values() collection of a lazily loaded cache does not supports remove() method");
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return BaseLazyMap.this.containsValue(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                boolean outContains = false;
                if (!CollectionUtils.isNullOrEmpty(c) && !((Set)BaseLazyMap.this._keySetSupplier.get()).isEmpty()) {
                    outContains = true;
                    for (Object val : c) {
                        if (BaseLazyMap.this.containsValue(val)) continue;
                        outContains = false;
                        break;
                    }
                }
                return outContains;
            }

            @Override
            public Object[] toArray() {
                return BaseLazyMap.this.currentEntries().values().toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                Collection values = BaseLazyMap.this.currentEntries().values();
                return values.toArray(a);
            }
        };
        return outCol;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AbstractUnmodifiableEntriesSet outEntrySet = new AbstractUnmodifiableEntriesSet<Map.Entry<K, V>>(this._actualKeys()){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private Iterator<K> _keySetIterator;
                    {
                        this._keySetIterator = _keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._keySetIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object nextKey = this._keySetIterator.next();
                        return Maps.immutableEntry(nextKey, BaseLazyMap.this.get(nextKey));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("The values() collection of a lazily loaded cache does not supports remove() method");
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry me = (Map.Entry)o;
                return BaseLazyMap.this.containsKey(me.getKey());
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                boolean outContains = false;
                if (!CollectionUtils.isNullOrEmpty(c) && !((Set)BaseLazyMap.this._keySetSupplier.get()).isEmpty()) {
                    outContains = true;
                    for (Object entry : c) {
                        Map.Entry me = (Map.Entry)entry;
                        if (BaseLazyMap.this.containsKey(me.getKey())) continue;
                        outContains = false;
                        break;
                    }
                }
                return outContains;
            }

            @Override
            public Object[] toArray() {
                return BaseLazyMap.this.currentEntries().entrySet().toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                Set entries = BaseLazyMap.this.currentEntries().entrySet();
                return entries.toArray(a);
            }
        };
        return outEntrySet;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        V outVal = this.get(key);
        if (outVal != null && (outVal = this.removeFromCurrentEntries(key)) != null) {
            this._changesTracker.trackEntryRemoval(key);
        }
        return outVal;
    }

    @Override
    public void clear() {
        for (K k : this.currentEntries().keySet()) {
            this._changesTracker.trackEntryRemoval(k);
        }
        this.clearCurrentEntries();
    }

    @Override
    public boolean removeLazily(K key) {
        if (key == null) {
            return false;
        }
        boolean existsKey = this.containsKey(key);
        if (existsKey) {
            if (this.isLoaded(key)) {
                this.removeFromCurrentEntries(key);
            }
            this._changesTracker.trackEntryRemoval(key);
        }
        return existsKey;
    }

    protected Set<K> _actualKeys() {
        return this._changesTracker.currentKeys((Set)this._keySetSupplier.get());
    }

    @Override
    public Map<K, V> loadedEntriesAsMap() {
        return this.currentEntries();
    }

    @Override
    public Set<Map.Entry<K, V>> loadedEntrySet() {
        return this.currentEntries().entrySet();
    }

    @Override
    public Set<K> loadedKeySet() {
        return this.currentEntries().keySet();
    }

    @Override
    public Collection<V> loadedValues() {
        return this.currentEntries().values();
    }

    @Override
    public Set<K> newKeys() {
        return this._changesTracker.getNewEntries();
    }

    @Override
    public Set<K> removedKeys() {
        return this._changesTracker.getRemovedEntries();
    }

    @Override
    public Set<K> notNewOrRemovedKeys() {
        return this.notNewOrRemovedKeys(false);
    }

    @Override
    public Set<K> notNewOrRemovedKeys(boolean onlyLoaded) {
        Set setToFilter = onlyLoaded ? this.currentEntries().keySet() : (Set)this._keySetSupplier.get();
        return Sets.filter((Set)setToFilter, (Predicate)Predicates.not(this._changesTracker.newOrDeletedEntriesFilter));
    }

    @Override
    public Map<K, V> newEntries() {
        Map outEntries = null;
        final Set<K> newKeys = this.newKeys();
        if (!CollectionUtils.isNullOrEmpty(newKeys)) {
            Predicate filter = new Predicate<K>(){

                public boolean apply(K key) {
                    return newKeys.contains(key);
                }
            };
            outEntries = Maps.filterKeys((Map)this, (Predicate)filter);
        }
        return outEntries;
    }

    @Override
    public Map<K, V> notNewOrRemovedEntries() {
        return this.notNewOrRemovedEntries(false);
    }

    @Override
    public Map<K, V> notNewOrRemovedEntries(boolean onlyLoaded) {
        Map outEntries = null;
        final Set<K> notNewOrRemovedKeys = this.notNewOrRemovedKeys(onlyLoaded);
        if (!CollectionUtils.isNullOrEmpty(notNewOrRemovedKeys)) {
            Predicate filter = new Predicate<K>(){

                public boolean apply(K key) {
                    return notNewOrRemovedKeys.contains(key);
                }
            };
            outEntries = Maps.filterKeys((Map)this, (Predicate)filter);
        }
        return outEntries;
    }

    @Override
    public Set<K> conciliateKeySet(Set<K> suppliedKeySet, Predicate<V> filter) {
        Set outKeys = suppliedKeySet;
        if (this._changesTracker.isDirty()) {
            Set<K> newKeys;
            final Set<K> removedKeys = this._changesTracker.getRemovedEntries();
            if (!CollectionUtils.isNullOrEmpty(removedKeys)) {
                outKeys = Sets.filter(outKeys, (Predicate)new Predicate<K>(){

                    public boolean apply(K oid) {
                        return !removedKeys.contains(oid);
                    }
                });
            }
            if (!CollectionUtils.isNullOrEmpty(newKeys = this._changesTracker.getNewEntries())) {
                Map matchingValues = Maps.filterValues(this.loadedEntriesAsMap(), filter);
                outKeys.addAll(matchingValues.keySet());
            }
        }
        return outKeys;
    }

    @Override
    public Map<K, V> filterEntriesWithKeys(Set<K> keys, boolean onlyLoaded) {
        Predicate filter = new Predicate<K>(){

            public boolean apply(K oid) {
                return BaseLazyMap.this._actualKeys().contains(oid);
            }
        };
        Map<K, V> mapToFilter = onlyLoaded ? this.loadedEntriesAsMap() : this;
        Map outMap = Maps.filterKeys((Map)mapToFilter, (Predicate)filter);
        return outMap;
    }

    public boolean isDirty() {
        return this._changesTracker.isDirty();
    }

    public boolean isNew() {
        return this._changesTracker.isNew();
    }

    public boolean isThisDirty() {
        return this._changesTracker.isThisDirty();
    }

    public boolean isTracking() {
        return this._changesTracker.isTracking();
    }

    public void resetDirty() {
        this._changesTracker.resetDirty();
    }

    public void setNew(boolean arg0) {
        this._changesTracker.setNew(arg0);
    }

    public void setThisDirty(boolean arg0) {
        this._changesTracker.setThisDirty(arg0);
    }

    public void setThisTrackableObjectTrackingState(boolean arg0) {
        this._changesTracker.setThisTrackableObjectTrackingState(arg0);
    }

    public void startTrackingChangesInState(boolean arg0) {
        this._changesTracker.startTrackingChangesInState(arg0);
    }

    public void stopTrackingChangesInState(boolean arg0) {
        this._changesTracker.stopTrackingChangesInState(arg0);
    }

    static abstract class AbstractUnmodifiableEntriesSet<T>
    extends AbstractUnmodifiableSet<T> {
        protected final Set<?> _keys;

        public AbstractUnmodifiableEntriesSet(Set<?> keys) {
            super("The values() / entrySet() collections of a lazily loaded cache");
            this._keys = keys;
        }

        @Override
        public int size() {
            return this._keys.size();
        }

        @Override
        public boolean isEmpty() {
            return this._keys.isEmpty();
        }
    }

    static abstract class AbstractUnmodifiableSet<T>
    implements Set<T> {
        private String _errMsg = "This map";

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException(String.valueOf(this._errMsg) + " does not supports add() method");
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException(String.valueOf(this._errMsg) + " does not supports addAll() method");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException(String.valueOf(this._errMsg) + " does not supports retainAll() method");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException(String.valueOf(this._errMsg) + " does not supports remove() method");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException(String.valueOf(this._errMsg) + " does not supports removeAll() method");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(String.valueOf(this._errMsg) + " does not supports clear() method");
        }

        @ConstructorProperties(value={"_errMsg"})
        public AbstractUnmodifiableSet(String _errMsg) {
            this._errMsg = _errMsg;
        }
    }
}

