/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.lazy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import r01f.types.dirtytrack.CollectionChangesTracker;
import r01f.types.lazy.LazyCollection;
import r01f.util.types.collections.CollectionUtils;

abstract class BaseLazyCollection<V>
implements LazyCollection<V> {
    boolean _isLoaded = false;
    CollectionChangesTracker<V> _changesTracker = new CollectionChangesTracker();

    BaseLazyCollection() {
    }

    protected abstract Collection<V> supplyValues();

    protected abstract boolean addInCurrentEntries(V var1);

    protected abstract boolean removeFromCurrentEntries(V var1);

    protected abstract void clearCurrentEntries();

    protected abstract Collection<V> currentEntries();

    private void _supply() {
        if (this._isLoaded) {
            return;
        }
        this.supplyValues();
        this._isLoaded = true;
    }

    @Override
    public int size() {
        this._supply();
        return this.currentEntries().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(V e) {
        this._supply();
        boolean outResult = this.addInCurrentEntries(e);
        if (outResult) {
            this._changesTracker.trackEntryInsertion(e);
        }
        return outResult;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean outModif = false;
        if (!CollectionUtils.isNullOrEmpty(c)) {
            for (V v : c) {
                outModif |= this.add(v);
            }
        }
        return outModif;
    }

    @Override
    public boolean remove(Object o) {
        this._supply();
        boolean outResult = this.removeFromCurrentEntries(o);
        if (outResult) {
            this._changesTracker.trackEntryRemoval(o);
        }
        return outResult;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean outModif = false;
        if (!CollectionUtils.isNullOrEmpty(c)) {
            for (Object v : c) {
                outModif |= this.remove(v);
            }
        }
        return outModif;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this._supply();
        boolean outModif = false;
        if (!CollectionUtils.isNullOrEmpty(c)) {
            for (V v : this.currentEntries()) {
                if (c.contains(v)) continue;
                outModif |= this.remove(v);
            }
        }
        return outModif;
    }

    @Override
    public void clear() {
        this._supply();
        for (V v : this.currentEntries()) {
            this._changesTracker.trackEntryRemoval(v);
        }
        this.clearCurrentEntries();
    }

    @Override
    public boolean contains(Object o) {
        this._supply();
        return this.currentEntries().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this._supply();
        return this.currentEntries().containsAll(c);
    }

    @Override
    public Iterator<V> iterator() {
        this._supply();
        return this.currentEntries().iterator();
    }

    @Override
    public Object[] toArray() {
        this._supply();
        return this.currentEntries().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this._supply();
        return this.currentEntries().toArray(a);
    }

    @Override
    public Set<V> newEntries() {
        return this._changesTracker.getNewEntries();
    }

    @Override
    public Set<V> removedEntries() {
        return this._changesTracker.getRemovedEntries();
    }

    @Override
    public Set<V> notNewOrRemovedEntries() {
        return Sets.newHashSet((Iterable)Collections2.filter(this.currentEntries(), (Predicate)Predicates.not(this._changesTracker.newOrDeletedEntriesFilter)));
    }

    public boolean isDirty() {
        return this._changesTracker.isDirty();
    }

    public boolean isNew() {
        return this._changesTracker.isNew();
    }

    public boolean isThisDirty() {
        return this._changesTracker.isThisDirty();
    }

    public boolean isTracking() {
        return this._changesTracker.isTracking();
    }

    public void resetDirty() {
        this._changesTracker.resetDirty();
    }

    public void setNew(boolean arg0) {
        this._changesTracker.setNew(arg0);
    }

    public void setThisDirty(boolean arg0) {
        this._changesTracker.setThisDirty(arg0);
    }

    public void setThisTrackableObjectTrackingState(boolean arg0) {
        this._changesTracker.setThisTrackableObjectTrackingState(arg0);
    }

    public void startTrackingChangesInState(boolean arg0) {
        this._changesTracker.startTrackingChangesInState(arg0);
    }

    public void stopTrackingChangesInState(boolean arg0) {
        this._changesTracker.stopTrackingChangesInState(arg0);
    }
}

