/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.dirtytrack;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import r01f.aspects.dirtytrack.DirtyStateTrackable;
import r01f.debug.Debuggable;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;

public class CollectionChangesTracker<K>
implements DirtyStateTrackable,
Serializable,
Debuggable {
    private static final long serialVersionUID = -190729036750079312L;
    private Set<K> _newEntries;
    private Set<K> _removedEntries;
    private boolean _dirty = false;
    private boolean _tracking = true;
    public Predicate<K> newEntriesFilter = new Predicate<K>(){

        public boolean apply(K key) {
            return CollectionChangesTracker.this.getNewEntries().contains(key);
        }
    };
    public Predicate<K> deletedEntriesFilter = new Predicate<K>(){

        public boolean apply(K key) {
            return CollectionChangesTracker.this.getRemovedEntries().contains(key);
        }
    };
    public Predicate<K> newOrDeletedEntriesFilter = Predicates.or(this.newEntriesFilter, this.deletedEntriesFilter);

    public void trackEntryInsertion(K key) {
        if (!this._tracking) {
            return;
        }
        if (this._removedEntries != null && this._removedEntries.contains(key)) {
            this._removedEntries.remove(key);
        } else if (this._newEntries != null && !this._newEntries.contains(key)) {
            if (!this._newEntries.contains(key)) {
                this._newEntries.add(key);
            }
        } else {
            if (this._newEntries == null) {
                this._newEntries = new HashSet<K>();
            }
            if (!this._newEntries.contains(key)) {
                this._newEntries.add(key);
            }
        }
        this._dirty = true;
    }

    public void trackEntryRemoval(K key) {
        if (!this._tracking) {
            return;
        }
        if (this._newEntries != null && this._newEntries.contains(key)) {
            this._newEntries.remove(key);
        } else if (this._removedEntries != null && !this._removedEntries.contains(key)) {
            if (!this._removedEntries.contains(key)) {
                this._removedEntries.add(key);
            }
        } else {
            if (this._removedEntries == null) {
                this._removedEntries = new HashSet<K>();
            }
            if (!this._removedEntries.contains(key)) {
                this._removedEntries.add(key);
            }
        }
        this._dirty = true;
    }

    public Set<K> currentKeys(Set<K> originalKeys) {
        Sets.SetView originalPlusNew = !CollectionUtils.isNullOrEmpty(this._newEntries) ? Sets.union(originalKeys, this._newEntries) : originalKeys;
        Sets.SetView originalPlusNewWithoutRemoved = !CollectionUtils.isNullOrEmpty(this._removedEntries) ? Sets.filter((Set)originalPlusNew, (Predicate)new Predicate<K>(){

            public boolean apply(K key) {
                return !CollectionChangesTracker.this.getRemovedEntries().contains(key);
            }
        }) : originalPlusNew;
        return originalPlusNewWithoutRemoved;
    }

    public void resetDirty() {
        if (this._newEntries != null) {
            this._newEntries = null;
        }
        if (this._removedEntries != null) {
            this._removedEntries = null;
        }
        this._dirty = false;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean isThisDirty() {
        return this.isDirty();
    }

    public void setThisDirty(boolean newDirty) {
        this.resetDirty();
    }

    public boolean isNew() {
        return false;
    }

    public void setNew(boolean isNew) {
    }

    public boolean isTracking() {
        return this._tracking;
    }

    public void setThisTrackableObjectTrackingState(boolean state) {
        this._tracking = state;
    }

    public void startTrackingChangesInState(boolean startTrackingInChilds) {
        this._tracking = true;
    }

    public void stopTrackingChangesInState(boolean stopTrackingInChilds) {
        this._tracking = false;
    }

    @Override
    public String debugInfo() {
        return Strings.create(50).add((CharSequence)"\r\n\t-         New entries : ").add(this._newEntries != null ? this._newEntries.size() : 0).add((CharSequence)" > ").add((CharSequence)CollectionChangesTracker._mapKeysToString(this._newEntries)).add((CharSequence)"\r\n\t-     Removed entries : ").add(this._removedEntries != null ? this._removedEntries.size() : 0).add((CharSequence)" > ").add((CharSequence)CollectionChangesTracker._mapKeysToString(this._removedEntries)).asString();
    }

    private static <K> StringBuffer _mapKeysToString(Collection<K> keys) {
        StringBuffer sb = new StringBuffer();
        if (keys != null) {
            Iterator<K> it = keys.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb;
    }

    public Set<K> getNewEntries() {
        return this._newEntries;
    }

    public Set<K> getRemovedEntries() {
        return this._removedEntries;
    }

    public static interface DirtyStateTrackableNotDelegatedToKeySetChangesTracker {
        public void resetDirty();
    }
}

