/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.dirtytrack;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import r01f.debug.Debuggable;
import r01f.types.dirtytrack.ChangesTrackableMap;
import r01f.types.dirtytrack.CollectionChangesTracker;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;

public class ChangesTrackedMap<K, V>
implements ChangesTrackableMap<K, V>,
Serializable,
Debuggable {
    private static final long serialVersionUID = -7817465496832765428L;
    private final Map<K, V> _currentEntries;
    CollectionChangesTracker<K> _changesTracker = new CollectionChangesTracker();

    @Override
    public V put(K key, V value) {
        V outValue = this._currentEntries.put(key, value);
        this._changesTracker.trackEntryInsertion(key);
        return outValue;
    }

    @Override
    public V remove(Object key) {
        V outValue = this._currentEntries.remove(key);
        if (outValue != null) {
            this._changesTracker.trackEntryRemoval(key);
        }
        return outValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (!CollectionUtils.isNullOrEmpty(m)) {
            for (Map.Entry<K, V> me : m.entrySet()) {
                this.put(me.getKey(), me.getValue());
            }
        }
    }

    @Override
    public void clear() {
        for (K k : this._currentEntries.keySet()) {
            this._changesTracker.trackEntryRemoval(k);
        }
        this._currentEntries.clear();
    }

    @Override
    public Set<K> newKeys() {
        return this._changesTracker.getNewEntries();
    }

    @Override
    public Set<K> removedKeys() {
        return this._changesTracker.getRemovedEntries();
    }

    @Override
    public Set<K> notNewOrRemovedKeys() {
        return this._changesTracker.newEntriesFilter != null ? Sets.filter(this._currentEntries.keySet(), this._changesTracker.newEntriesFilter) : this._currentEntries.keySet();
    }

    @Override
    public Map<K, V> newEntries() {
        Map outEntries = null;
        final Set<K> newKeys = this.newKeys();
        if (!CollectionUtils.isNullOrEmpty(newKeys)) {
            Predicate filter = new Predicate<K>(){

                public boolean apply(K key) {
                    return newKeys.contains(key);
                }
            };
            outEntries = Maps.filterKeys((Map)this, (Predicate)filter);
        }
        return outEntries;
    }

    @Override
    public Map<K, V> notNewOrRemovedEntries() {
        Map outEntries = null;
        final Set<K> notNewOrRemovedKeys = this.notNewOrRemovedKeys();
        if (!CollectionUtils.isNullOrEmpty(notNewOrRemovedKeys)) {
            Predicate filter = new Predicate<K>(){

                public boolean apply(K key) {
                    return notNewOrRemovedKeys.contains(key);
                }
            };
            outEntries = Maps.filterKeys((Map)this, (Predicate)filter);
        }
        return outEntries;
    }

    @Override
    public String debugInfo() {
        return Strings.of((CharSequence)"MapChangesTracker debug info:").add((CharSequence)"\r\n\t-Original map entries : ").add(this._currentEntries != null ? this._currentEntries.size() : 0).add((CharSequence)" > ").add((CharSequence)ChangesTrackedMap._mapKeysToString(this._currentEntries.keySet())).add((CharSequence)(this._changesTracker != null ? this._changesTracker.debugInfo() : "")).asString();
    }

    private static <K> StringBuffer _mapKeysToString(Collection<K> keys) {
        StringBuffer sb = new StringBuffer();
        if (keys != null) {
            Iterator<K> it = keys.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb;
    }

    @ConstructorProperties(value={"_currentEntries"})
    public ChangesTrackedMap(Map<K, V> _currentEntries) {
        this._currentEntries = _currentEntries;
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this._currentEntries.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this._currentEntries.containsValue(arg0);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._currentEntries.entrySet();
    }

    @Override
    public V get(Object arg0) {
        return this._currentEntries.get(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this._currentEntries.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this._currentEntries.keySet();
    }

    @Override
    public int size() {
        return this._currentEntries.size();
    }

    @Override
    public Collection<V> values() {
        return this._currentEntries.values();
    }

    public boolean isDirty() {
        return this._changesTracker.isDirty();
    }

    public boolean isNew() {
        return this._changesTracker.isNew();
    }

    public boolean isThisDirty() {
        return this._changesTracker.isThisDirty();
    }

    public boolean isTracking() {
        return this._changesTracker.isTracking();
    }

    public void resetDirty() {
        this._changesTracker.resetDirty();
    }

    public void setNew(boolean arg0) {
        this._changesTracker.setNew(arg0);
    }

    public void setThisDirty(boolean arg0) {
        this._changesTracker.setThisDirty(arg0);
    }

    public void setThisTrackableObjectTrackingState(boolean arg0) {
        this._changesTracker.setThisTrackableObjectTrackingState(arg0);
    }

    public void startTrackingChangesInState(boolean arg0) {
        this._changesTracker.startTrackingChangesInState(arg0);
    }

    public void stopTrackingChangesInState(boolean arg0) {
        this._changesTracker.stopTrackingChangesInState(arg0);
    }
}

