/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.dirtytrack;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import r01f.types.dirtytrack.ChangesTrackableCollection;
import r01f.types.dirtytrack.CollectionChangesTracker;
import r01f.util.types.collections.CollectionUtils;

public class ChangesTrackedCollection<V>
implements ChangesTrackableCollection<V>,
Serializable {
    private static final long serialVersionUID = 6436452238780837143L;
    final Collection<V> _currentEntries;
    CollectionChangesTracker<V> _changesTracker = new CollectionChangesTracker();

    @Override
    public boolean add(V e) {
        boolean outResult = this._currentEntries.add(e);
        if (outResult) {
            this._changesTracker.trackEntryInsertion(e);
        }
        return outResult;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean outModif = false;
        if (!CollectionUtils.isNullOrEmpty(c)) {
            for (V v : c) {
                outModif |= this.add(v);
            }
        }
        return outModif;
    }

    @Override
    public boolean remove(Object o) {
        boolean outResult = this._currentEntries.remove(o);
        if (outResult) {
            this._changesTracker.trackEntryRemoval(o);
        }
        return outResult;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean outModif = false;
        if (!CollectionUtils.isNullOrEmpty(c)) {
            for (Object v : c) {
                outModif |= this.remove(v);
            }
        }
        return outModif;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean outModif = false;
        if (!CollectionUtils.isNullOrEmpty(c)) {
            for (V v : this._currentEntries) {
                if (c.contains(v)) continue;
                outModif |= this.remove(v);
            }
        }
        return outModif;
    }

    @Override
    public void clear() {
        for (V v : this._currentEntries) {
            this._changesTracker.trackEntryRemoval(v);
        }
        this._currentEntries.clear();
    }

    @Override
    public Set<V> newEntries() {
        return this._changesTracker != null ? this._changesTracker.getNewEntries() : null;
    }

    @Override
    public Set<V> removedEntries() {
        return this._changesTracker != null ? this._changesTracker.getRemovedEntries() : null;
    }

    @Override
    public Set<V> notNewOrRemovedEntries() {
        Collection outCol = this._changesTracker != null ? Collections2.filter(this._currentEntries, this._changesTracker.newEntriesFilter) : this._currentEntries;
        return Sets.newHashSet(outCol);
    }

    @ConstructorProperties(value={"_currentEntries"})
    public ChangesTrackedCollection(Collection<V> _currentEntries) {
        this._currentEntries = _currentEntries;
    }

    @Override
    public boolean contains(Object arg0) {
        return this._currentEntries.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this._currentEntries.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this._currentEntries.isEmpty();
    }

    @Override
    public Iterator<V> iterator() {
        return this._currentEntries.iterator();
    }

    @Override
    public int size() {
        return this._currentEntries.size();
    }

    @Override
    public Object[] toArray() {
        return this._currentEntries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this._currentEntries.toArray(arg0);
    }

    public boolean isDirty() {
        return this._changesTracker.isDirty();
    }

    public boolean isNew() {
        return this._changesTracker.isNew();
    }

    public boolean isThisDirty() {
        return this._changesTracker.isThisDirty();
    }

    public boolean isTracking() {
        return this._changesTracker.isTracking();
    }

    public void resetDirty() {
        this._changesTracker.resetDirty();
    }

    public void setNew(boolean arg0) {
        this._changesTracker.setNew(arg0);
    }

    public void setThisDirty(boolean arg0) {
        this._changesTracker.setThisDirty(arg0);
    }

    public void setThisTrackableObjectTrackingState(boolean arg0) {
        this._changesTracker.setThisTrackableObjectTrackingState(arg0);
    }

    public void startTrackingChangesInState(boolean arg0) {
        this._changesTracker.startTrackingChangesInState(arg0);
    }

    public void stopTrackingChangesInState(boolean arg0) {
        this._changesTracker.stopTrackingChangesInState(arg0);
    }
}

