/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.contact;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import r01f.types.contact.ContactMail;
import r01f.types.contact.ContactPhone;
import r01f.types.contact.ContactSocialNetwork;
import r01f.types.contact.ContactWeb;

public class ContactInfo
implements Serializable {
    private static final long serialVersionUID = 8960930452114541680L;
    private String _person;
    private Map<String, ContactPhone> _phones;
    private Map<String, ContactSocialNetwork> _socialNetworks;
    private Map<String, ContactMail> _mailAddresses;
    private Map<String, ContactWeb> _webSites;

    public ContactInfo addPhone(String id, ContactPhone phone) {
        if (this._phones == null) {
            this._phones = Maps.newHashMap();
        }
        this._phones.put(id, phone);
        return this;
    }

    public ContactPhone removePhone(String id) {
        return this._phones != null ? this._phones.remove(id) : null;
    }

    public ContactInfo addSocialNetwork(String id, ContactSocialNetwork net) {
        if (this._socialNetworks == null) {
            this._socialNetworks = Maps.newHashMap();
        }
        this._socialNetworks.put(id, net);
        return this;
    }

    public ContactSocialNetwork removeSocialNetwork(String id) {
        return this._socialNetworks != null ? this._socialNetworks.remove(id) : null;
    }

    public ContactInfo addMailAddress(String id, ContactMail mail) {
        if (this._mailAddresses == null) {
            this._mailAddresses = Maps.newHashMap();
        }
        this._mailAddresses.put(id, mail);
        return this;
    }

    public ContactMail removeMailAddress(String id) {
        return this._mailAddresses != null ? this._mailAddresses.remove(id) : null;
    }

    public ContactInfo addWebSite(String id, ContactWeb web) {
        if (this._webSites == null) {
            this._webSites = Maps.newHashMap();
        }
        this._webSites.put(id, web);
        return this;
    }

    public ContactWeb removeWebSite(String id) {
        return this._webSites != null ? this._webSites.remove(id) : null;
    }

    public String getPerson() {
        return this._person;
    }

    public void setPerson(String _person) {
        this._person = _person;
    }

    public Map<String, ContactPhone> getPhones() {
        return this._phones;
    }

    public void setPhones(Map<String, ContactPhone> _phones) {
        this._phones = _phones;
    }

    public Map<String, ContactSocialNetwork> getSocialNetworks() {
        return this._socialNetworks;
    }

    public void setSocialNetworks(Map<String, ContactSocialNetwork> _socialNetworks) {
        this._socialNetworks = _socialNetworks;
    }

    public Map<String, ContactMail> getMailAddresses() {
        return this._mailAddresses;
    }

    public void setMailAddresses(Map<String, ContactMail> _mailAddresses) {
        this._mailAddresses = _mailAddresses;
    }

    public Map<String, ContactWeb> getWebSites() {
        return this._webSites;
    }

    public void setWebSites(Map<String, ContactWeb> _webSites) {
        this._webSites = _webSites;
    }
}

