/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.collections;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import r01f.aspects.lazyload.LazyMapSupplier;
import r01f.types.lazy.LazyCachedMap;
import r01f.types.lazy.LazyCollectionsInterfaces;
import r01f.types.lazy.LazyNotCachedMap;

public class TestCollectionUtils {
    public static void main(String[] args) {
        Map<String, String> cache = new LazyCachedMapBuilder().instanceFor(null);
        Map<String, String> noCache = new LazyHashMapBuilder().instanceFor(null);
        try {
            Map<String, String> mapToTest = noCache;
            int i = 0;
            while (i < 3) {
                System.out.println("\r\n\r\n\r\nITERACION " + i + " *********************");
                System.out.println("****************************");
                System.out.println("KeySet =================");
                for (String string : mapToTest.keySet()) {
                    System.out.println("-->" + string);
                }
                System.out.println("Values =================");
                for (String string : mapToTest.values()) {
                    System.out.println("-->" + string);
                }
                mapToTest.put("cuatro", "cuatro");
                mapToTest.remove("uno");
                System.out.println("Entries =================");
                for (Map.Entry entry : mapToTest.entrySet()) {
                    System.out.println("-->" + (String)entry.getKey() + ":" + (String)entry.getValue());
                }
                System.out.println("--->" + mapToTest.get("cinco"));
                Thread.sleep(700L);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    static abstract class BaseLazyMapProvider
    implements LazyMapSupplier<String, String, TestCollectionUtils> {
        private final Set<String> keys = new TreeSet<String>(Arrays.asList("uno", "dos", "tres"));
        protected final LazyCollectionsInterfaces.KeyIntrospector<String, String> keyIntrospector = new LazyCollectionsInterfaces.KeyIntrospector<String, String>(){

            @Override
            public String of(String obj) {
                return obj;
            }
        };
        protected final LazyCollectionsInterfaces.MapKeySetSupplier<String, MyParentObj> keySetSupplier = new LazyCollectionsInterfaces.MapKeySetSupplier<String, MyParentObj>(){

            @Override
            public Set<String> keysFor(MyParentObj obj) {
                System.out.println("> loading keys");
                return BaseLazyMapProvider.this.keys;
            }
        };
        protected final LazyCollectionsInterfaces.MapValuesSupplier<String, String> valuesSupplier = new LazyCollectionsInterfaces.MapValuesSupplier<String, String>(){

            @Override
            public String loadValue(String key) {
                System.out.println("> loading value for key " + key);
                return BaseLazyMapProvider.this.keys.contains(key) ? String.valueOf(key) + " value" : null;
            }
        };

        BaseLazyMapProvider() {
        }
    }

    static class LazyCachedMapBuilder
    extends BaseLazyMapProvider {
        LazyCachedMapBuilder() {
        }

        public Map<String, String> instanceFor(TestCollectionUtils parentObj) {
            Map<String, String> cache = LazyCachedMap.builder().loadKeySetWith(this.keySetSupplier, new MyParentObj()).loadValuesWith(this.valuesSupplier).introspectKeyFromValueWith(this.keyIntrospector).expiringEntriesEvery(1L, TimeUnit.SECONDS).build();
            return cache;
        }
    }

    static class LazyHashMapBuilder
    extends BaseLazyMapProvider {
        LazyHashMapBuilder() {
        }

        public Map<String, String> instanceFor(TestCollectionUtils parentObj) {
            Map<String, String> noCache = LazyNotCachedMap.builder().loadKeySetWith(this.keySetSupplier, new MyParentObj()).loadValuesWith(this.valuesSupplier).introspectKeyFromValueWith(this.keyIntrospector).build();
            return noCache;
        }
    }

    public static class MyParentObj {
        private String _myProp;

        public String get_myProp() {
            return this._myProp;
        }
    }
}

