/*
 * Decompiled with CFR 0.152.
 */
package r01f.types.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Object NULL_KEY = new Object();
    private Entry<K, V>[] _table;
    private int _size;
    private int _threshold;
    private float _loadFactor;
    private final ReferenceQueue<K> _queue = new ReferenceQueue();
    private volatile int _modCount;
    private transient Set<Map.Entry<K, V>> _entrySet = null;
    private volatile transient Set<K> _keySet = null;
    private volatile transient Collection<V> _values = null;

    public SoftHashMap() {
        this._loadFactor = 0.75f;
        this._threshold = 16;
        this._table = new Entry[16];
    }

    public SoftHashMap(int initialCapacity, float loadFactor) {
        this._init(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SoftHashMap(Map<? extends K, ? extends V> otherMap) {
        int capacity = Math.max((int)((float)otherMap.size() / 0.75f) + 1, 16);
        this._init(capacity, 0.75f);
        this.putAll(otherMap);
    }

    private void _init(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        int theInitialCapacity = initialCapacity;
        if (theInitialCapacity > 0x40000000) {
            theInitialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < theInitialCapacity) {
            capacity <<= 1;
        }
        this._table = new Entry[capacity];
        this._loadFactor = loadFactor;
        this._threshold = (int)((float)capacity * loadFactor);
    }

    @Override
    public int size() {
        if (this._size == 0) {
            return 0;
        }
        this._expungeStaleEntries();
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object key) {
        Object k = SoftHashMap._maskNull(key);
        int h = SoftHashMap._hash(k);
        Entry<K, V>[] tab = this._getTable();
        int index = SoftHashMap._indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (((Entry)e).hash == h && SoftHashMap.eq(k, e.get())) {
                return (V)((Entry)e).value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        K k = SoftHashMap._maskNull(key);
        int h = SoftHashMap._hash(k);
        Entry<K, V>[] tab = this._getTable();
        int i = SoftHashMap._indexFor(h, tab.length);
        Entry<K, V> e = tab[i];
        while (e != null) {
            if (h == ((Entry)e).hash && SoftHashMap.eq(k, e.get())) {
                Object oldValue = ((Entry)e).value;
                if (value != oldValue) {
                    ((Entry)e).value = value;
                }
                return (V)oldValue;
            }
            e = e.next;
        }
        ++this._modCount;
        e = tab[i];
        tab[i] = new Entry<K, V>(k, value, this._queue, h, e);
        if (++this._size >= this._threshold) {
            this._resize(tab.length * 2);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._getEntry(key) != null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this._threshold) {
            int targetCapacity = (int)((float)numKeysToBeAdded / this._loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            int newCapacity = this._table.length;
            while (newCapacity < targetCapacity) {
                newCapacity <<= 1;
            }
            if (newCapacity > this._table.length) {
                this._resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> prev;
        Object k = SoftHashMap._maskNull(key);
        int h = SoftHashMap._hash(k);
        Entry<K, V>[] tab = this._getTable();
        int i = SoftHashMap._indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == ((Entry)e).hash && SoftHashMap.eq(k, e.get())) {
                ++this._modCount;
                --this._size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return (V)((Entry)e).value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void clear() {
        while (this._queue.poll() != null) {
        }
        ++this._modCount;
        Entry<K, V>[] tab = this._table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this._size = 0;
        while (this._queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this._containsNullValue();
        }
        Entry<K, V>[] tab = this._getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (value.equals(((Entry)e).value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this._keySet;
        return ks != null ? ks : (this._keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this._values;
        return vs != null ? vs : (this._values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this._entrySet;
        return es != null ? es : (this._entrySet = new EntrySet());
    }

    private void _expungeStaleEntries() {
        Entry e;
        block0: while ((e = (Entry)this._queue.poll()) != null) {
            Entry<K, V> prev;
            int h = e.hash;
            int i = SoftHashMap._indexFor(h, this._table.length);
            Entry<K, V> p = prev = this._table[i];
            while (p != null) {
                Entry next = p.next;
                if (p == e) {
                    if (prev == e) {
                        this._table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    e.value = null;
                    --this._size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private Entry<K, V>[] _getTable() {
        this._expungeStaleEntries();
        return this._table;
    }

    private Entry<K, V> _getEntry(Object key) {
        Object k = SoftHashMap._maskNull(key);
        int h = SoftHashMap._hash(k);
        Entry<K, V>[] tab = this._getTable();
        int index = SoftHashMap._indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (!(e == null || ((Entry)e).hash == h && SoftHashMap.eq(k, e.get()))) {
            e = e.next;
        }
        return e;
    }

    private void _resize(int newCapacity) {
        Entry<K, V>[] oldTable = this._getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this._transfer(oldTable, newTable);
        this._table = newTable;
        if (this._size >= this._threshold / 2) {
            this._threshold = (int)((float)newCapacity * this._loadFactor);
        } else {
            this._expungeStaleEntries();
            this._transfer(newTable, oldTable);
            this._table = oldTable;
        }
    }

    private void _transfer(Entry<K, V>[] src, Entry<K, V>[] dest) {
        int j = 0;
        while (j < src.length) {
            Entry<K, V> e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    ((Entry)e).value = null;
                    --this._size;
                } else {
                    int i = SoftHashMap._indexFor(((Entry)e).hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
            ++j;
        }
    }

    private Entry<K, V> _removeMapping(Object o) {
        Entry<K, V> prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Entry<K, V>[] tab = this._getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = SoftHashMap._maskNull(entry.getKey());
        int h = SoftHashMap._hash(k);
        int i = SoftHashMap._indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == ((Entry)e).hash && e.equals(entry)) {
                ++this._modCount;
                --this._size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    private boolean _containsNullValue() {
        Entry<K, V>[] tab = this._getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (((Entry)e).value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private static <K> K _maskNull(K key) {
        return (K)(key == null ? NULL_KEY : key);
    }

    private static <K> K _unmaskNull(K key) {
        return key == NULL_KEY ? null : (K)key;
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    private static int _indexFor(int h, int length) {
        return h & length - 1;
    }

    private static int _hash(Object key) {
        return SoftHashMap._hash(key.hashCode());
    }

    private static int _hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static class Entry<K, V>
    extends SoftReference<K>
    implements Map.Entry<K, V> {
        private V value;
        private final int hash;
        Entry<K, V> next;

        Entry(K newKey, V newValue, ReferenceQueue<K> queue, int newHash, Entry<K, V> newNextEntry) {
            super(newKey, queue);
            this.value = newValue;
            this.hash = newHash;
            this.next = newNextEntry;
        }

        @Override
        public K getKey() {
            return (K)SoftHashMap._unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = SoftHashMap.this._getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return SoftHashMap.this._removeMapping(o) != null;
        }

        @Override
        public int size() {
            return SoftHashMap.this.size();
        }

        @Override
        public void clear() {
            SoftHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                c.add(new SimpleEntry(entry));
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                c.add(new SimpleEntry(entry));
            }
            return c.toArray(a);
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        int index;
        Entry<K, V> entry = null;
        Entry<K, V> lastReturned = null;
        int expectedModCount;
        Object nextKey;
        Object currentKey;

        HashIterator() {
            this.expectedModCount = SoftHashMap.this._modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = SoftHashMap.this.size() != 0 ? SoftHashMap.this._table.length : 0;
        }

        @Override
        public boolean hasNext() {
            Entry[] t = SoftHashMap.this._table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SoftHashMap.this._modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SoftHashMap.this.remove(this.currentKey);
            this.expectedModCount = SoftHashMap.this._modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }

        protected Entry<K, V> nextEntry() {
            if (SoftHashMap.this._modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SoftHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return SoftHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (SoftHashMap.this.containsKey(o)) {
                SoftHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SoftHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            for (Object v : this) {
                c.add(v);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList(this.size());
            for (Object v : this) {
                c.add(v);
            }
            return c.toArray(a);
        }
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry<K, V> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SoftHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return SoftHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            SoftHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            for (Object v : this) {
                c.add(v);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList(this.size());
            for (Object v : this) {
                c.add(v);
            }
            return c.toArray(a);
        }
    }
}

