/*
 * Decompiled with CFR 0.152.
 */
package r01f.types;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import r01f.util.types.collections.CollectionUtils;

public class Path
implements Serializable {
    private static final long serialVersionUID = -4132364966392988245L;
    private String _path;

    public Path(String newPath) {
        this._path = newPath != null ? newPath.trim() : null;
    }

    public Path(Path otherPath) {
        this._path = otherPath.toString();
    }

    public Path(String ... elements) {
        this._path = Path._composePath(elements);
    }

    public static Path of(String ... elements) {
        return new Path(Path._composePath(elements));
    }

    private static String _composePath(String ... elements) {
        String outPath = null;
        if (elements != null) {
            StringBuilder sb = new StringBuilder(elements.length * 10);
            Iterator<String> it = Arrays.asList(elements).iterator();
            while (it.hasNext()) {
                sb.append(it.next().trim());
                if (!it.hasNext()) continue;
                sb.append("/");
            }
            outPath = sb.toString();
        }
        return outPath;
    }

    public static Path of(String thePath) {
        if (thePath == null) {
            return new Path(new String[0]);
        }
        String[] pathElements = thePath.split("/");
        return Path.of(pathElements);
    }

    public String toString() {
        return this.asString();
    }

    public void setPath(Path otherPath) {
        if (otherPath == null) {
            return;
        }
        this._path = otherPath.asString();
    }

    public String asString() {
        String outPathStr = null;
        if (this._path != null && this._path.endsWith("/")) {
            outPathStr = this._path.substring(0, this._path.length() - 1);
        } else if (this._path != null) {
            outPathStr = this._path;
        }
        return outPathStr;
    }

    public String asString(Path parentPath) {
        String outPathStr = null;
        outPathStr = parentPath == null ? this.asString() : String.valueOf(parentPath.asString()) + "/" + Path._makeRelative(this._path);
        return outPathStr;
    }

    public String[] elements() {
        String[] outElements = this._path != null ? this._path.split("/") : null;
        return outElements;
    }

    public Path addElement(String element) {
        this._path = this._path == null ? element.trim() : (this._path.endsWith("/") ? String.valueOf(this._path) + element.trim() : String.valueOf(this._path) + "/" + element.trim());
        return this;
    }

    public Path addPath(Path otherPath) {
        this._path = this._path == null ? otherPath.toString() : (this._path.endsWith("/") ? String.valueOf(this._path) + Path._makeRelative(otherPath.asString()) : String.valueOf(this._path) + "/" + Path._makeRelative(otherPath.asString()));
        return this;
    }

    public Path prependPath(Path otherPath) {
        if (this._path == null) {
            this._path = otherPath.toString();
        }
        this._path = String.valueOf(otherPath.asString()) + "/" + Path._makeRelative(this._path);
        return this;
    }

    public Path makeRelative() {
        this._path = Path._makeRelative(this._path);
        return this;
    }

    public boolean isRelative() {
        return this._path != null ? !this._path.startsWith("/") : false;
    }

    public boolean isFilePath() {
        boolean outIsFile = false;
        String[] elements = this.elements();
        if (!CollectionUtils.isNullOrEmpty(elements)) {
            String last = elements[elements.length - 1];
            outIsFile = last.contains(".");
        }
        return outIsFile;
    }

    public boolean isFolderPath() {
        return !this.isFilePath();
    }

    public String fileExtension() {
        String file;
        int lastDotPos;
        String outExt = null;
        String[] elements = this.elements();
        if (!CollectionUtils.isNullOrEmpty(elements) && elements[elements.length - 1].contains(".") && (lastDotPos = (file = elements[elements.length - 1]).lastIndexOf(46)) < file.length() - 1) {
            outExt = file.substring(lastDotPos);
        }
        return outExt;
    }

    private static Path _makeRelative(Path path) {
        return new Path(Path._makeRelative(path.toString()));
    }

    private static String _makeRelative(String path) {
        String outPath = null;
        if (path != null && path.startsWith("/")) {
            outPath = path.substring(1);
        } else if (path != null) {
            outPath = path;
        }
        return outPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$_path = this._path;
        String other$_path = other._path;
        return !(this$_path == null ? other$_path != null : !this$_path.equals(other$_path));
    }

    public boolean canEqual(Object other) {
        return other instanceof Path;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $_path = this._path;
        result = result * 31 + ($_path == null ? 0 : $_path.hashCode());
        return result;
    }
}

