/*
 * Decompiled with CFR 0.152.
 */
package r01f.types;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import r01f.debug.Debuggable;

public class BitMap
implements Debuggable,
Serializable {
    private static final long serialVersionUID = -7795853546674157713L;
    private int _bitMap;

    public void incorporateBitMapInfo(BitMap otherFlags) {
        this._bitMap |= otherFlags.getBitMap();
    }

    protected boolean bitAt(int bitIndex) {
        return BitMap._getBit(this._bitMap, 31 - bitIndex - 1);
    }

    protected void setBitAt(int bitIndex) {
        this._bitMap = BitMap._setBit(this._bitMap, 31 - bitIndex - 1);
    }

    protected void clearBitAt(int bitIndex) {
        this._bitMap = BitMap._clearBit(this._bitMap, 31 - bitIndex - 1);
    }

    @Override
    public String debugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Mapa de bits: " + this._bitMap + " : " + Integer.toBinaryString(this._bitMap) + "\r\n");
        String currBitStr = "";
        int i = 0;
        while (i <= 30) {
            currBitStr = "  " + i;
            sb.append(String.valueOf(currBitStr.substring(currBitStr.length() - 2)) + "|");
            ++i;
        }
        sb.append("\r\n");
        i = 0;
        while (i <= 30) {
            currBitStr = this.bitAt(i) ? " 1" : " 0";
            sb.append(String.valueOf(currBitStr.substring(currBitStr.length() - 2)) + "|");
            ++i;
        }
        sb.append("\r\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i <= 30) {
            sb.append(this.bitAt(i) ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }

    private static int _getMask(int bitIndex) {
        return 1 << bitIndex;
    }

    public static int _setBit(int originalInt, int bitIndex) {
        return originalInt | BitMap._getMask(bitIndex);
    }

    public static int _clearBit(int originalInt, int bitIndex) {
        return originalInt & ~BitMap._getMask(bitIndex);
    }

    public static boolean _getBit(int integer, int bitIndex) {
        return (integer & BitMap._getMask(bitIndex)) != 0;
    }

    public int getBitMap() {
        return this._bitMap;
    }

    public void setBitMap(int _bitMap) {
        this._bitMap = _bitMap;
    }

    @ConstructorProperties(value={"_bitMap"})
    public BitMap(int _bitMap) {
        this._bitMap = _bitMap;
    }
}

