/*
 * Decompiled with CFR 0.152.
 */
package r01f.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import r01f.httpclient.HttpClient;
import r01f.resources.ResourcesLoaderBase;
import r01f.resources.ResourcesLoaderDef;
import r01f.util.types.Strings;

public class URLResourcesLoader
extends ResourcesLoaderBase {
    private String serverCharsetName = Charset.defaultCharset().name();
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;

    URLResourcesLoader(ResourcesLoaderDef def) {
        super.setDef(def);
    }

    @Override
    public InputStream getInputStream(String resourcePath, boolean reload) throws IOException {
        try {
            HttpURLConnection conx = this._getURLConnection(resourcePath, Charset.forName(this.serverCharsetName));
            InputStream is = conx.getInputStream();
            return is;
        }
        catch (IOException ioEx) {
            StringBuilder msg = new StringBuilder("Error al cargar un recurso de la url: " + resourcePath);
            if (this.proxyHost != null) {
                msg.append("(");
                msg.append(" proxy host:port=" + this.proxyHost + ":" + this.proxyPort);
                msg.append(" proxy usr/pwd=" + this.proxyUser + "/" + this.proxyPassword);
                msg.append(")");
            }
            throw new IOException(msg + " > " + ioEx.getMessage());
        }
    }

    @Override
    public Reader getReader(String resourcePath, boolean reload) throws IOException {
        return new InputStreamReader(this.getInputStream(resourcePath, reload));
    }

    private HttpURLConnection _getURLConnection(String url, Charset charset) throws IOException {
        HttpURLConnection conx = null;
        boolean useProxy = !Strings.isNullOrEmpty(this.proxyHost);
        conx = useProxy ? HttpClient.forUrl(url).usingCharset(charset).withoutParameters().usingGETRequestMethod().withConnectionTimeOut(10000L).usingProxy(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword).getConnection() : HttpClient.forUrl(url).usingCharset(charset).withoutParameters().usingGETRequestMethod().withConnectionTimeOut(10000L).getConnection();
        return conx;
    }

    public String getServerCharsetName() {
        return this.serverCharsetName;
    }

    public void setServerCharsetName(String serverCharsetName) {
        this.serverCharsetName = serverCharsetName;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }
}

