/*
 * Decompiled with CFR 0.152.
 */
package r01f.resources;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import r01f.debug.Debuggable;
import r01f.util.types.Strings;

public class ResourcesReloadControlDef
implements Debuggable {
    public static ResourcesReloadControlDef DEFAULT = new ResourcesReloadControlDef(){

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public ResourcesReloadPolicy getImpl() {
            return ResourcesReloadPolicy.NO_RELOAD;
        }
    };
    private boolean _enabled = true;
    private String _checkInterval = "-1";
    private ResourcesReloadPolicy _impl = ResourcesReloadPolicy.VOID;
    private Map<String, String> _controlProps;

    @Override
    public CharSequence debugInfo() {
        Strings.StringWrapper sw = Strings.create(100);
        sw.addCustomized("\r\n\t\t\t-enabled: {}", Boolean.toString(this._enabled)).addCustomized("\r\n\t\t\t-   impl: {}", this._impl.name()).addCustomized("\r\n\t\t\t-  props: ({})", this._controlProps == null ? "null" : Integer.toString(this._controlProps.size()));
        if (this._controlProps != null) {
            for (Map.Entry<String, String> prop : this._controlProps.entrySet()) {
                sw.addCustomized("\r\n\t\t\t\t-{}:{}", prop.getKey(), prop.getValue());
            }
        }
        return sw;
    }

    public long checkIntervalMillis() {
        Matcher m;
        long outMillis = -1L;
        if (this._checkInterval != null && (m = Pattern.compile("\\s*([0-9]+)\\s*(s|m|h)?\\s*").matcher(this._checkInterval)).matches()) {
            int periodValue = Integer.parseInt(m.group(1));
            if (m.groupCount() == 2) {
                String periodUnitStr = m.group(2);
                if (periodUnitStr.equalsIgnoreCase("s")) {
                    outMillis = periodValue * 1000;
                } else if (periodUnitStr.equalsIgnoreCase("m")) {
                    outMillis = periodValue * 60 * 1000;
                } else if (periodUnitStr.equalsIgnoreCase("h")) {
                    outMillis = periodValue * 60 * 60 * 1000;
                }
            } else {
                outMillis = periodValue * 1000;
            }
        }
        return outMillis;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean _enabled) {
        this._enabled = _enabled;
    }

    public String getCheckInterval() {
        return this._checkInterval;
    }

    public void setCheckInterval(String _checkInterval) {
        this._checkInterval = _checkInterval;
    }

    public ResourcesReloadPolicy getImpl() {
        return this._impl;
    }

    public void setImpl(ResourcesReloadPolicy _impl) {
        this._impl = _impl;
    }

    public Map<String, String> getControlProps() {
        return this._controlProps;
    }

    public void setControlProps(Map<String, String> _controlProps) {
        this._controlProps = _controlProps;
    }

    public static enum ResourcesReloadPolicy {
        BBDD,
        CONTENT_SERVER_FILE_LAST_MODIF_TIMESTAMP,
        FILE_LAST_MODIF_TIMESTAMP,
        PERIODIC,
        VOID,
        NO_RELOAD;

    }
}

